<?php
function yes_product_margenrechner_get_shipping_netto($weight,$shipping_country_id){
    // sgwID
    $query = yes_query(
        "SELECT shipping_graduation_weights_id FROM shipping_graduation_weights WHERE weight >=:weight ORDER BY weight ASC LIMIT 1",
        ['weight'=>$weight]
    );
    if(!sizeOf($query)){
        return 0;
    }
    $record = current($query);
    $sgwID = $record['shipping_graduation_weights_id'];
    
    // sggID
    $query = yes_query(
        "SELECT shipping_graduation_groups_id FROM shipping_graduation_countries WHERE country_id=:country_id",
        ['country_id'=>(int)$shipping_country_id]
    );
    if(!sizeOf($query)){
	$sggID = 999999;
    }else{
	$record = current($query);
	$sggID = $record['shipping_graduation_groups_id'];
    }
    
    $query = xtc_db_query(sprintf(
        "SELECT grad_value_cost FROM shipping_graduation_values WHERE shipping_graduation_weights_id='%d' AND shipping_graduation_groups_id='%d' ",
        $sgwID,$sggID
    ));
    $record = xtc_db_fetch_array($query);
    return $record['grad_value_cost'];
}

function yes_product_margenrechner_get_tax_rate(int $products_id, int $shipping_country_id){
    if( $shipping_country_id < 1 ){
        $shipping_country_id = STORE_COUNTRY;
        if( STORE_COUNTRY < 1 ){
            throw new Exception('Kein STORE_COUNTRY definiert. Wird in yes_product_margenrechner gebraucht.');
        }
    }
    
    $products_tax_class_id = yes_eu_oss_get_products_tax_class_id($products_id, $shipping_country_id);
    return xtc_get_tax_rate($products_tax_class_id,$shipping_country_id);
}

function yes_product_margenrechner_get_product_data(int $products_id){
    $query = yes_query(sprintf(
        "SELECT products_price,products_weight,packaging_costs FROM %s WHERE products_id=:products_id",
            TABLE_PRODUCTS
        ),['products_id'=>$products_id]
    );
    if(!sizeOf($query)){
	return [];
    }
    return current($query);
    
}


function yes_product_margenrechner($products_id,$src='shop',$shipping_country_id = STORE_COUNTRY,$return_array = false, $include_shipping = false){
    $product = yes_product_margenrechner_get_product_data($products_id);
    if(!sizeOf($product)){
        return 0; // unbekannter artikel
    }
    $calc = [
        'ek_netto'=>xtc_get_price_ek($products_id),
        'tax_rate'=>yes_product_margenrechner_get_tax_rate($products_id, $shipping_country_id),
        'packaging'=>($include_shipping) ? $product['packaging_costs'] : 0,
        'shipping_netto'=>($include_shipping) ? yes_product_margenrechner_get_shipping_netto(
                $product['products_weight'],$shipping_country_id
        ) : 0,
        'add_fixk'=>(defined('MARGENRECHNER_FIXKOSTEN_PERCENT'))?(MARGENRECHNER_FIXKOSTEN_PERCENT+100)/100 : 0,
        'add_ebay'=>(defined('MARGENRECHNER_EBAYFEE_PERCENT'))?(MARGENRECHNER_EBAYFEE_PERCENT+100)/100 : 0,
        'add_amaz'=>(defined('MARGENRECHNER_AMAZONFEE_PERCENT'))?(MARGENRECHNER_AMAZONFEE_PERCENT+100)/100 : 0,
        'add_hitm'=>(defined('MARGENRECHNER_HITMEISTERFEE_PERCENT'))?(MARGENRECHNER_HITMEISTERFEE_PERCENT+100)/100 : 0,
    ];
    $tax_multiplier = (($calc['tax_rate']+100)/100);
    $selbstkosten = ($calc['ek_netto']+$calc['packaging']);
    if($calc['add_fixk'] > 0){
        $selbstkosten = $selbstkosten * $calc['add_fixk'];
    }
    $vk_brutto =  $selbstkosten*$tax_multiplier;
    switch($src){
	case 'ebay':
            if($calc['add_ebay']>0){
                $ebay_price = ($selbstkosten*$calc['add_ebay'])-$selbstkosten;
                $vk_brutto =  ($ebay_price+$selbstkosten)*$tax_multiplier;
            }
	    break;
	case 'amazon':
            if($calc['add_amaz']>0){
                $amz_price = ($selbstkosten*$calc['add_amaz'])-$selbstkosten;
                $vk_brutto =  ($amz_price+$selbstkosten)*$tax_multiplier;
            }
	    break;
	case 'hitmeist':
            if($calc['add_hitm']>0){
                $hitmeist_price = ($selbstkosten*$calc['add_hitm'])-$selbstkosten;
                $vk_brutto =  ($hitmeist_price+$selbstkosten)*$tax_multiplier;
            }
	    break;
    }
    
    if(!$return_array){
	return $vk_brutto;
    }
    return array(
        'products_name'=>xtc_get_products_name($products_id),
        'ek_netto'=>$calc['ek_netto'],
        'fixkosten_prozentwert'=>$calc['add_fixk'],
        'shipping_netto'=>$calc['shipping_netto'],
        'packaging_costs'=>$calc['packaging'],
        'amazon_prozentwert'=>$calc['add_amaz'],
        'ebay_prozentwert'=>$calc['add_ebay'],
        'hitmeister_prozentwert'=>$calc['add_hitm'],
        'selbstkosten'=>$selbstkosten,
        'tax_prozentwert'=>$tax_multiplier,
        'ebay_price'=>$ebay_price,
        'amz_price'=>$amz_price,
        'vk_brutto'=>$vk_brutto
    );    
}