<?php
// the value -1: no depth restriction
define('CATEGORIES_STRUCT_MAX_DEPTH',-1);
if(!function_exists('yes_multisort')){
    require_once(DIR_FS_INC.'yes_multisort.inc.php');
}
function tree_add($tree, $parent_id, $object, $cat_id){
    // Only start from the given cat_id, ignore all other roots

    if($parent_id == 0 and $object['categories_id'] == $cat_id)
    {
        $tree[$object['categories_id']] = $object;
        return $tree;
    }
    if($tree)
    {
        foreach($tree as $key => $value)
        {
            $current = $tree[$key];
            // If this is the parent, add the object to it's children array
            if($current['categories_id'] == $parent_id)
            {
                $tree[$key]['children'][$object['categories_id']] = $object;
            }
            else
            {
                // If it's not in this level, look a level deeper on the current object.
                $tree[$key]['children'] = tree_add($current['children'], $parent_id, $object, $cat_id);
            }
        }
    }

    return $tree;
}
class category_item
{
    var $categories_id;
    var $depth;
    var $categories_name;
    var $parent_id;
    var $link_id;
    var $categories_image;
    var $categories_additional_image;
    var $heading_title;


    function __construct($cat_id, $depth, $cat_title, $cat_parent_id,$cat_link_id,$categories_image,$categories_additional_image,$heading_title){
        $this->categories_id = $cat_id;
        $this->depth = $depth;
        $this->categories_name = $cat_title;
        $this->parent_id = $cat_parent_id;
	$this->link_id = $cat_link_id;
	$this->categories_image = $categories_image;
	$this->categories_additional_image = $categories_additional_image;
	$this->heading_title = $heading_title;
    }
}
class SimpleXMLExtended extends SimpleXMLElement{    
  public function addCData($cdata_text){    
//	if(strstr(HTTP_SERVER,'localhost'))
	$cdata_text = yes_encode_string($cdata_text);
	$node= dom_import_simplexml($this);    
	$no = $node->ownerDocument;    
	$node->appendChild($no->createCDATASection($cdata_text));    
  }    
}    

class cat2XML{
    var $xml;
    var $languages_id;
	function _struct_get_categories($categories_array = '', $parent_id = '0',$level = 0) {
		$group_check = '';
		if (GROUP_CHECK == 'true') {
			$group_check = "and c.group_permission_".$_SESSION['customers_status']['customers_status_id']."=1 ";
		}
		$parent_id = xtc_db_prepare_input($parent_id);

		if (!is_array($categories_array)) $categories_array = array();
                $parameters = [
                    'parent_id'=>(int)$parent_id,
                ];
		$categories_query = "select
					      c.categories_id, cd.categories_name,c.categories_image,c.categories_additional_image,c.parent_id,c.link_id,c.sort_order,cd.categories_heading_title 
					      from " . TABLE_CATEGORIES . " c left join " . TABLE_CATEGORIES_DESCRIPTION . " cd using(categories_id)
					       where parent_id =:parent_id
					       and c.categories_status != 0
					       and cd.language_id = '" . $this->languages_id . "' ".$group_check;
		$categories_query .= "                                   order by sort_order, cd.categories_name";
		$categories_query  = yes_query($categories_query,$parameters);
		if(sizeOf($categories_query)){
		    foreach($categories_query as $categories) {
		      $categories['id'] = $categories['categories_id'];
		      $categories['text'] = $categories['categories_name'];
		      $categories['level'] = $level;
		      $categories_array[] = $categories;
		      if ($categories['categories_id'] != $parent_id) {
			if(CATEGORIES_STRUCT_MAX_DEPTH == -1 or CATEGORIES_STRUCT_MAX_DEPTH > $level){
				$categories_array = $this->_struct_get_categories($categories_array, $categories['categories_id'], $level+1);
			}
		      }
		    }
		}

		return $categories_array;
	}
	function build_list($cat_array, $item = '', $depth = 0){
	    global $template;
	    global $list;

	    foreach($cat_array as $category)
	    {
		$loop_item = "$item$category[categories_name]";
		$category_item = new category_item($category['categories_id'], $depth, $category['categories_name'], $category['parent_id'], $category['link_id'], $category['categories_image'], $category['categories_additional_image'], $category['categories_heading_title']);
		$list[] = $category_item;

		if(count($category['children']) > 0)
		{
		    $depth++;
		    $this->build_list($category['children'], $loop_item." > ", $depth);
		    $depth--;
		}

		$loop_item = '';
	    }

	    return $list;
	}
	
	function __construct( $languages_id){
	    $this->languages_id = $languages_id;
	}

	private function get_categories_from_db($group_check_customers_status = 0){





	    /*************************************************************/
	    // Builds the category list for the category select

	    $list = array();


	    /*************************************************************/
	    // Adds the object to the children array of the object with 
	    // a cat_id equal to $parent_id


	    $_categories = array();
	    $_categories_array = $this->_struct_get_categories($_categories,0);
	    $_categories_array = yes_multisort($_categories_array,'level');
	    $level_num = 0;
	    foreach($_categories_array as $c){
		    if($level_num < $c['level']){
			    $level_num = $c['level'];
		    }
	    }
	    $level = array();
	    for($i=0;$i<=$level_num;$i++){
		    $level[$i] = array();
		    foreach($_categories_array as $c){
			    if($i == $c['level']){
				    $level[$i][] = $c;
			    }
		    }
		    // HIER ENTSCHEIDEN WIE INNERHALB DES LEVELS SORTIERT WIRD
		    //$level[$i] = yes_multisort($level[$i],'text');
		    $level[$i] = yes_multisort($level[$i],'sort_order');
	    }
	    $_cats = array();
	    foreach($level as $l){
		    $_cats = array_merge($_cats,$l);
	    }
	    $_categories_array = $_cats;
	    $cat_tree = array();
	    foreach($_categories_array as $category){
		$children = array();

		$category['children'] = $children;

		$cat_id = $category['categories_id'];
		$cat_parent_id = $category['parent_id'];

		$cat_tree = tree_add($cat_tree, $cat_parent_id, $category, $cat_id);
	    }
	    //$cat_list = $this->build_list($cat_tree);
	    
	    return $cat_tree;
	}

	private function create_xml_struct($categories_array,$xml_node){
	    foreach($categories_array as $record){
		$CATEGORY = $xml_node->addChild('CATEGORY');
		$CATEGORY->addAttribute('ID',$record['categories_id']);
		$CATEGORY->addAttribute('PARENT',$record['parent_id']);
		$CATEGORY->addAttribute('LINK_ID',$record['link_id']);
		$CATEGORY->addAttribute('SORT_ORDER',$record['sort_order']);
		$CATEGORY->addAttribute('LEVEL',$record['level']);
		$CATEGORY->addChild('IMAGE',$record['categories_image']);
		$CATEGORY->addChild('ADDITIONAL_IMAGE',$record['categories_additional_image']);
		$NAME = $CATEGORY->addChild('NAME');
		$NAME->addCData(xtc_db_prepare_input($record['categories_name']));
		$HEADING_TITLE = $CATEGORY->addChild('HEADING_TITLE');
		$HEADING_TITLE->addCData(xtc_db_prepare_input($record['categories_heading_title']));
		if(isset($record['children']) and sizeOf($record['children'])){
		    $CHILDREN = $CATEGORY->addChild('CHILDREN');
		    $this->create_xml_struct($record['children'],$CHILDREN);
		}
	    }
	}
	
	public function create_xml_file($file){
            $encoding = strtoupper(CHARSET);
            $xmlstr = sprintf("<?xml version='1.0' encoding='%s' standalone='yes'?><CATEGORIES></CATEGORIES>",$encoding);
            $this->xml = new SimpleXMLExtended($xmlstr);
            $this->create_xml_struct($this->get_categories_from_db(),$this->xml);
            if(is_file($file))
                    unlink($file);
            $this->xml->asXML($file);
	}
}

