<?php
/**
 *
 * ALLE FUNKTIONEN DIE MAN FUER DAS AUSLESEN EINER/MEHRERER TRANSAKTION(EN) BRAUCHT
 */
require_once(DIR_FS_INC.'xtc_get_currencies_values,inc.php');
function xtc_get_ebay_users(){
	$env = (EBAY_TESTMODE == 1) ? 'sandbox' : 'production';
	$user_array = array();
	$user_query = xtc_db_query("SELECT user FROM ebay_auth WHERE environment='".$env."'");
	while($user = xtc_db_fetch_array($user_query)){
		$user_array[] = array('id'=>$user['user'],'text'=>$user['user']);
	}
	return $user_array;
}

function format_price($price_string, $price_special, $currency, $allow_tax, $tax_rate) {
    $currencies_value = xtc_get_currencies_values($currency);
    $currencies_data = array(
        'SYMBOL_LEFT' => $currencies_value['symbol_left'],
        'SYMBOL_RIGHT' => $currencies_value['symbol_right'],
        'DECIMAL_PLACES' => $currencies_value['decimal_places'],
        'VALUE' => $currencies_value['value']
    );

    // round price
    if ($allow_tax == 1){
        $price_string = $price_string/((100+$tax_rate)/100);
    }
    $price_string = precision($price_string, $currencies_data['DECIMAL_PLACES']);
    if ($price_special == '1') {
        $price_string = $currencies_data['SYMBOL_LEFT'] . ' ' . $price_string . ' ' . $currencies_data['SYMBOL_RIGHT'];
    }
    return $price_string;
}

function precision($number, $places) {
	$number = number_format($number, $places, '.', '');
	return $number;
}

function split_string($value){
	// WIR BASTELN VOR- UND NACHNAMEN
	$reg_fullname = array();
	$reg_fullname_array = array();
	
	$reg_fullname_ebay = $value;
	$reg_fullname_array = explode(" ",$reg_fullname_ebay);
	$reg_fullname[0] = $reg_fullname_array[0];
	if( count($reg_fullname_array) > 1 ) {
		for($i=1;$i<count($reg_fullname_array);$i++) {
			if(!isset($reg_fullname[1])){
				$reg_fullname[1] = '';
			}
			$reg_fullname[1] .= ' '.$reg_fullname_array[$i];
		}
	}
	return $reg_fullname;
}

function _get_country_name_from_code($iso_code){
    $countryname_query = xtc_db_query("SELECT countries_name FROM countries WHERE countries_iso_code_2='".$iso_code."'");
    $countryname = xtc_db_fetch_array($countryname_query);
    return $countryname['countries_name'];
}

function _get_country_id_from_code($iso_code){
    $countryid_query = xtc_db_query("SELECT countries_id FROM countries WHERE countries_iso_code_2='".$iso_code."'");
    $countryid = xtc_db_fetch_array($countryid_query);
    return $countryid['countries_id'];
}

function _get_country_code($value,$ebayid,$write_notice = true){
	global $EBAYAPI;
	$iso2 = $EBAYAPI->get_iso2_from_ebay_countryname($value);
    if( $iso2 != '' ){
    	return $iso2;
    }else{
	if($write_notice){
		$rec_array = array();
		$admin_access_query = xtc_db_query("SELECT customers_id FROM admin_access WHERE ebayapi_cart=1");
		while($admin_access = xtc_db_fetch_array($admin_access_query)){
			$rec_array[] = $admin_access['customers_id'];
		}
		$text = sprintf('In Auktion Nr. %s wurde das Land des Kaeufers als "%s" uebergeben. Diesem Wert konnte kein eindeutiges Land zugewiesen werden und in der Bestellung wurde als Default-Wert Germany hinterlegt.<p><i>Es kann oefter vorkommen das Ebay unvollstaendige oder fehlende Laenderkennungen uebergibt, damit es beim Versand nicht zu Problemen fuehrt, informiert Sie das YES System.</i></p>',$ebayid,$value);
		yes_write_notice('Fehlende Ebay-Land-Konvertierung',$text,0,$rec_array);
	}
    	return 'DE';
    }
}

function _ebay_country_code($code){
	$country_id_query = xtc_db_query("SELECT countries_name,countries_id FROM countries WHERE countries_iso_code_2='".xtc_db_input(strtoupper( $code ))."'");
	$country_id_res = xtc_db_fetch_array($country_id_query);
	return (($country_id_res['countries_id'] > 0)?$country_id_res['countries_id']:'81');
}

function _ebay_zone_id($country_id){
	// bastel zone-id
	$zone_query = xtc_db_query("SELECT zone_id FROM ".TABLE_ZONES." WHERE zone_country_id='".$country_id."'");
	$zone = xtc_db_fetch_array($zone_query);
	return $zone["zone_id"];
}

function _get_payment_method($trans,$item,$shipping_class){
	return 'moneyorder';
}

function strip_cdata($string) {
    preg_match_all('/<!\[cdata\[(.*?)\]\]>/is', $string, $matches);
    return str_replace($matches[0], $matches[1], $string);
}
