<?php
/* -----------------------------------------------------------------------------------------
   $Id: form_check.js.php,v 1.5 2020/02/11 13:02:41 ssh-511548-cvs Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(form_check.js.php,v 1.9 2003/05/19); www.oscommerce.com 
   (c) 2003	 nextcommerce (form_check.js.php,v 1.3 2003/08/13); www.nextcommerce.org 

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/

$lang_vars = parse_ini_file(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/lang_'.$_SESSION['language'].'.conf',true);
if ($lang_vars === false) {
  throw new Exception('Missing '.$_SESSION['language'].' language ini file');
}
$text_select_shipping_method = $lang_vars['checkout_shipping']['text_shipping'];
?>
<script type="text/javascript">
<!--
var form = "";
var submitted = false;
var error = false;
var error_message = "";
var vv_code_pre_check_success = false;

function check_input(field_name, field_size, message) {
  if (form.elements[field_name] && (form.elements[field_name].type != "hidden")) {
    var field_value = form.elements[field_name].value;

    if (field_value == '' || field_value.length < field_size) {
      error_message = error_message + "* " + message + "\n";
      error = true;
    }
  }
}

function check_radio(field_name, message) {
  var isChecked = false;
  if (form.elements[field_name] && (form.elements[field_name].type != "hidden")) {
    var radio = form.elements[field_name];

    for (var i=0; i<radio.length; i++) {
      if (radio[i].checked == true) {
        isChecked = true;
        break;
      }
    }
    if (isChecked === false) {
      error_message = error_message + "* " + message + "\n";
      error = true;
    }
  }
}

function check_select(field_name, field_default, message) {
  if (form.elements[field_name] && (form.elements[field_name].type != "hidden")) {
    var field_value = form.elements[field_name].value;

    if (field_value == field_default) {
      error_message = error_message + "* " + message + "\n";
      error = true;
    }
  }
}

function check_password(field_name_1, field_name_2, field_size, message_1, message_2) {
  if (form.elements[field_name_1] && (form.elements[field_name_1].type != "hidden")) {
    var password = form.elements[field_name_1].value;
    var confirmation = form.elements[field_name_2].value;

    if (password == '' || password.length < field_size) {
      error_message = error_message + "* " + message_1 + "\n";
      error = true;
    } else if (password != confirmation) {
      error_message = error_message + "* " + message_2 + "\n";
      error = true;
    }
  }
}

function check_password_new(field_name_1, field_name_2, field_name_3, field_size, message_1, message_2, message_3) {
  if (form.elements[field_name_1] && (form.elements[field_name_1].type != "hidden")) {
    var password_current = form.elements[field_name_1].value;
    var password_new = form.elements[field_name_2].value;
    var password_confirmation = form.elements[field_name_3].value;

    if (password_current == '' || password_current.length < field_size) {
      error_message = error_message + "* " + message_1 + "\n";
      error = true;
    } else if (password_new == '' || password_new.length < field_size) {
      error_message = error_message + "* " + message_2 + "\n";
      error = true;
    } else if (password_new != password_confirmation) {
      error_message = error_message + "* " + message_3 + "\n";
      error = true;
    }
  }
}

var form, error, error_message;
function check_form(form_name) {
  if (submitted == true) {
    alert("<?php echo JS_ERROR_SUBMITTED; ?>");
    return false;
  }
    error = false;
    error_message = "<?php echo JS_ERROR; ?>";
    form = document.forms[form_name];

<?php if (ACCOUNT_GENDER == 'true') { ?>
  check_radio("gender", "<?php echo ENTRY_GENDER_ERROR; ?>");
<?php } ?>

  check_input("firstname", <?php echo ENTRY_FIRST_NAME_MIN_LENGTH; ?>, "<?php echo ENTRY_FIRST_NAME_ERROR; ?>");
  check_input("lastname", <?php echo ENTRY_LAST_NAME_MIN_LENGTH; ?>, "<?php echo ENTRY_LAST_NAME_ERROR; ?>");

<?php if (ACCOUNT_DOB == 'true' and ENTRY_DOB_MIN_LENGTH > 0) echo '  check_input("dob", ' . ENTRY_DOB_MIN_LENGTH . ', "' . ENTRY_DATE_OF_BIRTH_ERROR . '");' . "\n"; ?>

  check_input("email_address", <?php echo ENTRY_EMAIL_ADDRESS_MIN_LENGTH; ?>, "<?php echo ENTRY_EMAIL_ADDRESS_ERROR; ?>");
  check_input("street_address", <?php echo ENTRY_STREET_ADDRESS_MIN_LENGTH; ?>, "<?php echo ENTRY_STREET_ADDRESS_ERROR; ?>");
  check_input("postcode", <?php echo ENTRY_POSTCODE_MIN_LENGTH; ?>, "<?php echo ENTRY_POST_CODE_ERROR; ?>");
  check_input("city", <?php echo ENTRY_CITY_MIN_LENGTH; ?>, "<?php echo ENTRY_CITY_ERROR; ?>");

<?php if (ACCOUNT_STATE == 'true') echo '  check_input("state", ' . ENTRY_STATE_MIN_LENGTH . ', "' . ENTRY_STATE_ERROR . '");' . "\n"; ?>

  check_select("country", "", "<?php echo ENTRY_COUNTRY_ERROR; ?>");

<?php if(ENTRY_TELEPHONE_MIN_LENGTH > 0) { ?>  check_input("telephone", <?php echo ENTRY_TELEPHONE_MIN_LENGTH; ?>, "<?php echo ENTRY_TELEPHONE_NUMBER_ERROR; ?>"); <?php } ?>

  if($('select[name="guest_account"]').length < 1 || $('select[name="guest_account"]').val() !== 'guest'){
    check_password("password", "confirmation", <?php echo ENTRY_PASSWORD_MIN_LENGTH; ?>, "<?php echo ENTRY_PASSWORD_ERROR; ?>", "<?php echo ENTRY_PASSWORD_ERROR_NOT_MATCHING; ?>");
    check_password_new("password_current", "password_new", "password_confirmation", <?php echo ENTRY_PASSWORD_MIN_LENGTH; ?>, "<?php echo ENTRY_PASSWORD_ERROR; ?>", "<?php echo ENTRY_PASSWORD_NEW_ERROR; ?>", "<?php echo ENTRY_PASSWORD_NEW_ERROR_NOT_MATCHING; ?>");
  }
  
  if($('input[name="vat"]').length){
        if($('input[name="vat"]').val() == ''){
            error_message = error_message + "* <?php echo ENTRY_VAT_ERROR; ?>\n";
        }
  }
  
<?php

if(basename($_SERVER['SCRIPT_FILENAME']) == FILENAME_CHECKOUT_SHIPPING and defined('USE_EASYCHECKOUT') and constant('USE_EASYCHECKOUT') == 'True'){?>
  if($('input[name="shipping"]').length > 0 && $('input[name="shipping"]').attr('type') != 'hidden'){
    if($('input[name="shipping"]:checked').length < 1){
      alert('<?php echo $text_select_shipping_method; ?>');
      return false;
    }
  }
<?php
}
// -----------------------------------------------------------------------------
// WENN AUF DER FORMULARSEITE DIE FUNKTION vvcode_ajax_check DEKLARIERT IST
// WIRD VVCODE VOR DEM SUBMIT BEREITS GEPRUEFT
// -----------------------------------------------------------------------------
?>
    if($('input[name="allow_email_shipper"]').length){
            if(!$('input[name="allow_email_shipper"]').is(':checked')){
                alert($('input[name="allow_email_shipper"]').data('errormsg'));
                $('input[name="allow_email_shipper"]').focus();
                return false;
            }
    }
    if($('form[name="'+form_name+'"] input[name="payment"]').length){
        let selected_payment = $('form[name="'+form_name+'"] input[name="payment"]:checked').val();
        if(selected_payment == 'klarna_yes_pay_later'){
          if($('form[name="checkout_payment"] input[name="klarna_authorization_token"]').length < 1){
            authorizeKlarna();
            return false;
          }
        }
    }

    if($('input[name="vvcode"]').length && !vv_code_pre_check_success && typeof vvcode_ajax_check === "function"){
        vvcode_ajax_check(error, error_message);
        return false;
    }else if( $('#yesCaptchaContainer').length && !vv_code_pre_check_success ){
	testsolve($(form_name));
        return false;
    }else{
        if (error == true) {
            alert(error_message);
            return false;
        } else {
            submitted = true;
            return true;
        }
    }
}
<?php
if(basename($_SERVER['SCRIPT_FILENAME']) == FILENAME_CREATE_ACCOUNT){
    $account_selected = (!isset($_GET['account_type']) or empty($_GET['account_type']))?false:true;
    $account_select_str = '';
    $js_predefined_vars = [];
    $yesCA_content_div = '';
    $csID = -1;
    $customers_status_array = xtc_get_customers_statuses();
    $display_cs = [];
    
    foreach($customers_status_array as $cs){
    	if(!sizeOf($cs)){
	    	continue;
	}
        $cs_allow = true;
        switch($cs['id']){
            case 0:
            case 1:
            case DEFAULT_CUSTOMERS_STATUS_ID:
                $cs_allow = false;
                break;
        }
        if(!$cs_allow){
            continue; // gast und admin nicht auswaehlbar
        }
        switch($cs['csa_public']){
            case 1:
                $display_cs[] = ['id'=>$cs['id'],
                    'text'=>$cs['text'],
                    'description'=>(!empty($cs['customers_status_description']))?$cs['customers_status_description']:'Es wurde keine Beschreibung für Kundengruppe '.$cs['text'].' hinterlegt.',
                ];
                break;
        }
    }
    if(sizeOf($display_cs)>0){
        $smarty = new yesSmarty();
        $smarty->assign([
            'CUSTOMERS_STATUSES'=>$display_cs,
            'DEFAULT_CUSTOMERS_STATUS_ID'=>DEFAULT_CUSTOMERS_STATUS_ID,
            'language'=>(isset($_SESSION['language']) and !empty($_SESSION['language']))?$_SESSION['language']:'german',
        ]);
        $yesCA_tpl_file = DIR_FS_CATALOG.'templates'.DIRECTORY_SEPARATOR.CURRENT_TEMPLATE.DIRECTORY_SEPARATOR.'module'.DIRECTORY_SEPARATOR.'create_account.select_account_type.html';
        if(!is_file($yesCA_tpl_file) or !is_readable($yesCA_tpl_file)){
            $js_predefined_vars[] = sprintf("alert('Das Template \"%s\" zur Anzeige der Kundengruppen-Auswahl bei Shop Registrierung fehlt oder ist nicht lesbar.');\n",basename($yesCA_tpl_file));
        }else{
            $yesCA_content = $smarty->fetch($yesCA_tpl_file);
            $yesCA_content_div = sprintf('<div id="yesCA_div">%s</div>',$yesCA_content);
        }
    }
    if(!$account_selected){
        if(sizeOf($display_cs)>1){
            $js_predefined_vars[] = sprintf("var yesCA_account_selected=%s;\n",(($account_selected)?'true':'false'));
        }else{
            $csID = DEFAULT_CUSTOMERS_STATUS_ID;
        }
    }else{
        $csID = (int)xtc_db_input($_GET['account_type']);
        $found = false;
        if($csID == DEFAULT_CUSTOMERS_STATUS_ID){
            // privater Kunde
            $found = true;
        }else{
            foreach($display_cs as $cs){
                if($cs['id'] == $csID){
                    $found = true;
                }
            }
        }
        if(!$found){
            $js_predefined_vars[] = sprintf("var yesCA_account_selected=false;\n");
            $csID = -1;
        }else{
            $js_predefined_vars[] = sprintf("var yesCA_account_selected=true;\n");
            $yesCA_content_div = '';
        }
    }
    if($csID > 0){
        $current_cs = -1;
        foreach($display_cs as $cs){
            if($cs['id'] == $csID){
                $current_cs = $cs;
            }
        }
    }
?>
$(function(){
    <?php echo implode("\n",$js_predefined_vars);?>
    if(!yesCA_account_selected){
        if(!$('form[name="create_account"]').length){
            alert('YES System Template Fehler: Im create_account Template konnte keine Form mit dem Namen "create_account" gefunden werden.');
        }else{
            $('form[name="create_account"]').after($('#yesCA_div').html());
            $('form[name="create_account"]').remove();
            $('#yesCA_div').remove();
        }
    }
    if($('select[name="guest_account"]').val() == 'guest'){
        $('#pw').hide();
        $('#pw input[name="password"]').prop('required',false);
        $('#pw input[name="confirmation"]').prop('required',false);
    }
    $('select[name="guest_account"]').on('change',function(){
        if($(this).val() == 'guest'){
            $('#pw').hide();
            $('#pw input[name="password"]').prop('required',false);
            $('#pw input[name="confirmation"]').prop('required',false);
        }else{
            $('#pw').show();
            $('#pw input[name="password"]').prop('required',true);
            $('#pw input[name="confirmation"]').prop('required',true);
        }
    });
});
<?php
}
?>

//-->
</script>
<?php
if(isset($yesCA_content_div) and !empty($yesCA_content_div)){
    echo $yesCA_content_div;    
}
?>
