<?php
/* -----------------------------------------------------------------------------------------
   $Id: sessions.php,v 1.1 2011/04/06 13:46:22 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(sessions.php,v 1.16 2003/04/02); www.oscommerce.com 
   (c) 2003	 nextcommerce (sessions.php,v 1.5 2003/08/13); www.nextcommerce.org 

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/

if(!defined('SESSION_TIMEOUT_CUSTOMER')){
    $qid = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'SESSION_TIMEOUT_CUSTOMER'");    
    $value = xtc_db_fetch_array($qid);
    $SESS_LIFE = $value['configuration_value'];
}else{
    $SESS_LIFE = SESSION_TIMEOUT_CUSTOMER;
}
if($SESS_LIFE < 60) {
     $SESS_LIFE = 1440;
}
@ini_set("session.gc_maxlifetime", $SESS_LIFE);
@ini_set("session.gc_probability", 100);

  if (STORE_SESSIONS == 'mysql') {
    if (!$SESS_LIFE = get_cfg_var('session.gc_maxlifetime')) {
      $SESS_LIFE = 1440;
    }

    function _sess_open($save_path, $session_name) {
      return true;
    }

    function _sess_close() {
      return true;
    }

    function _sess_read($key) {
        $value = yes_query(
            "select value from " . TABLE_SESSIONS . " where sesskey =:sess_key and expiry > '" . time() . "'",
            ['sess_key'=> $key],
            true
        );
        if ($value['value']) {
            return $value['value'];
        }
        return false;
    }

    function _sess_write($key, $val) {
        global $SESS_LIFE;

        $expiry = time() + $SESS_LIFE;
        $value = addslashes($val);

        $total = yes_query(
            "select count(*) as total from " . TABLE_SESSIONS . " where sesskey =:sess_key",
            ['sess_key'=>$key],
            true
        );

        if ($total['total'] > 0) {
            $update_sql_array = [
                'expiry' => $expiry, 
                'value' => $value
            ];
            return yes_db_perform(TABLE_SESSIONS, $update_sql_array,'update', [
                'sesskey' => $key
            ]);
        } else {
            $insert_sql_array = [
                'sesskey'=>$key,
                'expiry'=>$expiry,
                'value'=>$value
            ];
            return yes_db_perform(TABLE_SESSIONS,$insert_sql_array);
        }
    }

    function _sess_destroy($key) {
        return yes_query("delete from " . TABLE_SESSIONS . " where sesskey =:sess_key",
              ['sess_key'=>$key]
        );
    }

    function _sess_gc($maxlifetime) {
      xtc_db_query("delete from " . TABLE_SESSIONS . " where expiry < '" . time() . "'");

      return true;
    }

    session_set_save_handler('_sess_open', '_sess_close', '_sess_read', '_sess_write', '_sess_destroy', '_sess_gc');
  }

  function xtc_session_start() {
    return session_start();
  }

  function xtc_session_register($variable) {
    global $session_started;

    if ($session_started == true) {
      return session_register($variable);
    }
  }

  function xtc_session_is_registered($variable) {
    return isset($variable);
  }

  function xtc_session_unregister($variable) {
    return session_unregister($variable);
  }

  function xtc_session_id($sessid = '') {
    if (!empty($sessid)) {
      return session_id($sessid);
    } else {
      return session_id();
    }
  }

  function xtc_session_name($name = '') {
    if (!empty($name)) {
      return session_name($name);
    } else {
      return session_name();
    }
  }

  function xtc_session_close() {
    if (function_exists('session_close')) {
      return session_close();
    }
  }

  function xtc_session_destroy() {
    return session_destroy();
  }

  function xtc_session_save_path($path = '') {
    if (!empty($path)) {
      return session_save_path($path);
    } else {
      return session_save_path();
    }
  }

  function xtc_session_recreate() {

      $session_backup = $_SESSION;

      unset($_COOKIE[xtc_session_name()]);

      xtc_session_destroy();

      if (STORE_SESSIONS == 'mysql') {
        session_set_save_handler('_sess_open', '_sess_close', '_sess_read', '_sess_write', '_sess_destroy', '_sess_gc');
      }

      xtc_session_start();

      $_SESSION = $session_backup;
      unset($session_backup);
    
  }
?>