<?php
define('YES_DEV_SERVER','https://yes-a177922.de/');
define('YES_CACHE_LIFETIME_SHORT',3600); // 1 Hour
define('YES_CACHE_LIFETIME_LONG',86400); // 1 Day

function yes_get_store_country_id(){
    if (!isset($_SESSION['customer_id'])) {
        // WIRD IN index.php BEREITGESTELLT
        if(isset($_SESSION['TMP_STORE_COUNTRY_ID'])){
            return $_SESSION['TMP_STORE_COUNTRY_ID'];
        }
        return STORE_COUNTRY;
    }else{
        unset($_SESSION['TMP_STORE_COUNTRY_ID']);
    }
    if(isset($_SESSION['customer_country_id'])){
        return $_SESSION['customer_country_id'];
    }
    if(!isset($_SESSION['customer_default_address_id'])){
        return STORE_COUNTRY;
    }
    $item = \YES4Trade\Model\address_book::get_by_address_book_id((int)$_SESSION['customer_default_address_id']);
    if($item !== null){
        return $item->entry_country_id;
    }
    return 0;
}
if(!function_exists('yes_debug')){
    function yes_debug($debug){
        echo '</div></td></tr></table>';
        echo '<table border="1" width="80%" bgcolor="#000000">';
        echo '<tr><th><font color="#FFFFFF">';
        $bt = current(debug_backtrace());
        printf('%s @line %s',basename($bt['file']),$bt['line']);
        echo 'Debug Type: &quot;'.getType($debug).'&quot;&nbsp;';
        echo '</font></th></tr>';
        if((getType($debug) == 'string' and strlen($debug)<50) or empty($debug)){
            printf('<tr><td style="color: #FFF;">Debug STR: <input type="text" value="%s" style="width:80%%;"></td></tr>',$debug);
        }else{
            echo '<tr><td><textarea style="width:100%;height:500px;" wrap="virtual" name="debugcont'.date('his').'">';
            print_r($debug);
            echo '</textarea></td></tr>';
        }
        echo '</table>';
    }
}
function yes_shop_debug($debug,$customers_id=1){
    if($_SESSION['customer_id'] != $customers_id){
        return false;
    }
    yes_debug($debug);
}
// S T A R T   E R R O R   H A N D L E R
// Error handler, passes flow over the exception logger with new ErrorException.
function log_error( $num, $str, $file, $line, $context = null )
{
    log_exception( new ErrorException( $str, 0, $num, $file, $line ) );
}

// Uncaught exception handler.
function myErrorHandler($fehlercode, $fehlertext, $fehlerdatei, $fehlerzeile)
{
    if (!(error_reporting() & $fehlercode)) {
        // Dieser Fehlercode ist nicht in error_reporting enthalten
        return;
    }
    switch ($fehlercode) {
	case E_USER_ERROR:
	    drawErrorOutput();
	    if(isset($_SESSION['customer_id']) and $_SESSION['customer_id'] == 1){
		yes_debug($fehlercode.': error@'.$fehlerdatei.' in line '.$fehlerzeile.': '.$fehlertext);
	    }
	    exit(1);
	    break;
	case E_NOTICE:
	    break;
	default:
	    if(isset($_SESSION['customer_id']) and $_SESSION['customer_id'] == 1){
		    yes_debug($fehlercode.': error@'.$fehlerdatei.' in line '.$fehlerzeile.': '.$fehlertext);
        }
    }
  
    return true;
}

define('TEXT_LOG_EXCEPTION_DESC_german','Beim Aufrufen der von Ihnen gew&uuml;nschten Seite, kam es zu einem Fehler. Unser Technik-Team  wurde automatisch benachrichtigt. Wir werden versuchen den Fehler so schnell wie m&ouml;glich zu beheben.');
define('TEXT_LOG_EXCEPTION_DESC_english','An error occured. The admins would fix the problem.');
function yes_print_exception( string $err_string){
    $cli = (strpos(PHP_SAPI, 'cli') !== false) ? true : false;
    $backlink_target = (defined('HTTPS_SERVER'))?constant('HTTPS_SERVER') : constant('HTTPS_CATALOG_SERVER');
	$backlink = sprintf('<a style="font-size:1.4em;" href="%s"><u>%s</u></a>',$backlink_target,'Startpage');
    $html = '';
    $html .= "<div style='margin: 0 auto;border: 1px solid black;background-color: #FFF;width:600px;font-family: arial, helvetics, sans-serif;text-align:center;font-size:14px;word-wrap: break-word;  overflow-wrap: break-word;'>";
    $html .= sprintf("<h2>Ohje, da ist was schief gelaufen :-(</h2>");
	$html .= sprintf('<img src="%s/images/page_error.jpg" border="0" alt="Error" />',$backlink_target);
    $inc_lang = yes_get_language_folder();
    if($inc_lang != 'german'){
        $inc_lang = 'english';
    }
	$html .= sprintf('<p>%s</p>',sprintf(constant('TEXT_LOG_EXCEPTION_DESC_'.$inc_lang)));
	$html .= sprintf('<p>%s</p>',$backlink);
	$get_str = log_exception_get_param_string_from_array($_GET,0,'');
	$post_str = log_exception_get_param_string_from_array($_POST,0,'');
        
    $error_in_file = (isset($_SERVER['SCRIPT_NAME'])) ? $_SERVER['SCRIPT_NAME'] : $_SERVER['PHP_SELF'];
    $deb_str = '';
    foreach($_SERVER as $k=>$v){
        if(is_countable($v)){
            $v = print_r($v,true);
        }
        $deb_str .= sprintf('<b>%s</b> = %s<br />',$k,$v);
    }
    
	$err = "<b>Server:</b> ".HTTP_SERVER."<br />\r\n".
		"<b>PHP Version:</b> ".phpversion()."<br />\r\n".
		"<b>Client Browser:</b> ".($_SERVER['HTTP_USER_AGENT']??'cron')."<br />\r\n".
		"<b>Client IP:</b> ".($_SERVER['REMOTE_ADDR']??'cron')."<br />\r\n".
		"<b>File:</b> ".$error_in_file."<br />\r\n";
    if(!empty($get_str)){
		$err .= "<b>Parameter (GET)</b>\r\n".$get_str."<br />\r\n";
    }
    if(!empty($post_str)){
		$err .= "<b>Parameter (POST)</b>\r\n".$post_str."<br />\r\n";
    }
	$err .= '<hr noshade="noshade" />'.nl2br($err_string);
    if($cli) {
        $err_cli = strip_tags(nl2br($err));
    }
    $html .= $err;
	if( (isset($_SESSION['customer_id']) and $_SESSION['customer_id'] == 1) or strpos($backlink_target,'//localhost') > -1){
        if($cli){
            die($err_cli);
        }
        die(sprintf(
            '<div style="text-align:left;padding:4px;width:100%%;background-color: #000;color:#FFF;font-family: system, monospace;font-size: 0.8em;overflow-wrap: break-word;word-wrap: break-word;white-space: pre-wrap;">%s</div></div>',
            $err
        ));
	}else{
        $mail_header = array(
            "MIME-Version: 1.0",
            "Content-type: text/html; charset=".CHARSET,
            'X-Mailer: PHP/' . phpversion()
        );
	    mail('b.agri@yes4trade.de,m.aspeleiter@yes-websolutions.de','Fehler im Admin',$err,implode("\r\n",$mail_header));
	}
	exit;
}

function log_exception_handler($exception){
    // these are our templates
    $traceline = "#%s %s(%s): %s(%s)";
    $msg = "PHP Fatal error:  Uncaught exception '%s' with message '%s' in %s:%s\nStack trace:\n%s\n  thrown in %s on line %s";

    // alter your trace as you please, here
    $trace = $exception->getTrace();
    foreach ($trace as $key => $stackPoint) {
        // I'm converting arguments to their type
        // (prevents passwords from ever getting logged as anything other than 'string')
	if(isset($trace[$key]['args']))
	    $trace[$key]['args'] = array_map('gettype', $trace[$key]['args']);
	else
	    $trace[$key]['args'] = array();
    }

    // build your tracelines
    $result = array();
    foreach ($trace as $key => $stackPoint) {
        $result[] = sprintf(
            $traceline,
            $key,
            $stackPoint['file'],
            $stackPoint['line'],
            $stackPoint['function'],
            implode(', ', $stackPoint['args'])
        );
    }
    // trace always ends with {main}
    if(!isset($key))$key=0;
    $result[] = '#' . ++$key . ' {main}';

    // write tracelines into main template
    $msg = sprintf(
        $msg,
        get_class($exception),
        $exception->getMessage(),
        $exception->getFile(),
        $exception->getLine(),
        implode("\n", $result),
        $exception->getFile(),
        $exception->getLine()
    );

    // log or echo as you please
    yes_print_exception("<b>Message:</b> ".$msg."\r\n");
}

function  log_exception_get_param_string_from_array($request_array,$depth = 0,$response_str = ''){
	$tab = "\t";
	for($i=0;$i<$depth;$i++){
		$tab .= "\t";
	}
	foreach($request_array as $key => $value){
		if(!is_array($value)){
			$response_str .= $tab."$key=$value\r\n";
		}else{
			$response_str .= $tab."$key=array\r\n";
			$response_str = log_exception_get_param_string_from_array($value,$depth+1,$response_str);
		}
	}
	return $response_str;
}


function log_exception( \Exception $e ){
    yes_print_exception($e->getMessage());
}



// Checks for a fatal error, work around for set_error_handler not working on fatal errors.
function check_for_fatal(){
    $error = error_get_last();
    if (is_countable($error) and ($error["type"] == E_ERROR or $error['type'] == E_USER_ERROR )){
        log_error( $error["type"], $error["message"], $error["file"], $error["line"] );
    }
}
// E N D   E R R O R   H A N D L E R


function xtDBquery($query) {
    if (DB_CACHE=='true') {
        $result=xtc_db_queryCached($query);
    } else {
        $result=xtc_db_query($query);
    }
    return $result;
}


function xtc_category_link($cID,$cName='') {
    $cName = xtc_cleanName($cName);
    $link = 'cat=c'.$cID.'_'.$cName.'.html';
    return $link;
}
function xtc_cleanName($name) {
    return urlencode($name);
}

function xtc_product_link($pID, $name='') {
    $pName = xtc_cleanName($name);
    $link = 'info=p'.$pID.'_'.$pName.'.html';
    return $link;
}
function CacheCheck(){
    if (USE_CACHE == 'false'){
        return false;
    }else{
        return true;
    }
}

if(!function_exists('_is_test')){
	function _is_test($pID){
		return true;
		if(stristr(HTTP_SERVER,'localhost') or stristr(HTTP_SERVER,'agri.abcde.biz/yes'))
				return true;
		if(defined('AUCTIONCOUNTER_TEST_MODE') and AUCTIONCOUNTER_TEST_MODE == 'True'){
			$query = yes_db_query(sprintf(
				"SELECT pID FROM test_products WHERE pID='%s'",
				$pID
			));
			if(yes_db_num_rows($query)){
				return true;
			}
		}
		return false;
	}
}

function my_yesdsgvo_psr4_autoloader($class) {
    // replace namespace separators with directory separators in the relative 
    // class name, append with .php
    $class_path = str_replace('\\', '/', $class);
    
    $file =  __DIR__ . '/classes/' . $class_path . '.php';

    // if the file exists, require it
    if (file_exists($file)) {
        require $file;
    }
}

function yes_mail($body, $burak = false, $subject = Null){
    $plain_body = strip_tags($body);
    // 2. Kürzen auf gewünschte Zeichenanzahl
    $short_body = mb_substr($plain_body, 0, 50);
    if(strlen($plain_body) > 50){
        $short_body .= '[...]';
    }

    $subject = ($subject === Null) ? $short_body : $subject;
    $recipient = 'm.aspeleiter@yes-websolutions.de';
    $fw = '';
    if($burak === true){
        $fw = 'agri@yes-websolutions.de';
    }
    if(!function_exists('xtc_php_mail')){
            require_once(DIR_FS_INC . 'xtc_php_mail.inc.php');
    }
    $from_email_address = EMAIL_SUPPORT_ADDRESS;
    $from_email_name = STORE_NAME;
    $to_email_address = $recipient;
    $to_name = 'YES Entwicklung (Shop)';
    $forwarding_to = $fw;
    $reply_address = $to_email_address;
    $reply_address_name = $to_name;
    $path_to_attachement = '';
    $path_to_more_attachements = '';
    $email_subject = $subject;
    $message_body_html = sprintf('<pre><code>%s</code></pre>',$body);
    $message_body_plain = $body;
    xtc_php_mail($from_email_address, $from_email_name, $to_email_address, $to_name, $forwarding_to, $reply_address, $reply_address_name, $path_to_attachement, $path_to_more_attachements, $email_subject, $message_body_html, $message_body_plain);
}
function yes_mail_debug(string $text, bool $burak = false, string $subject = ''){
    $bt = current(debug_backtrace());
    $debug_pos = sprintf('%s @line %s',basename($bt['file']),$bt['line']);
    $nachricht = sprintf("%s [%s]\t\n\r\n%s\r\n%s\r\n\r\n%s",STORE_NAME,HTTP_SERVER,$debug_pos,$text,date('Y-m-d H:i:s'));
    $servr = (defined('HTTP_SERVER'))?constant('HTTP_SERVER'):constant('HTTP_CATALOG_SERVER');
    if(strstr($servr,'localhost')){
        file_put_contents('/mnt/efa53e84-19eb-432b-9636-ad4c06d8b8d9/apache2/test/debugmail_'.date('Ymd_His').'.txt',$nachricht);
        return;
    }
    yes_mail($nachricht, $burak, (!empty($subject)?$subject:null));
}

function yes_get_store_zone_id(){
    if (!isset($_SESSION['customer_id'])) {
        return STORE_ZONE;
    }
    return $_SESSION['customer_zone_id'];
}

function yes_getErrorReporting(){
	return ini_get('error_reporting');
}

function yes_setErrorReporting($error_reporting){
	if(!empty($val))
		error_reporting($val);
}

function getErrorReportingValue(){
    $E_ERROR_CONSTANTS = [
        'E_ERROR'             => E_ERROR,
        'E_WARNING'           => E_WARNING,
        'E_PARSE'             => E_PARSE,
        'E_NOTICE'            => E_NOTICE,
        'E_CORE_ERROR'        => E_CORE_ERROR,
        'E_CORE_WARNING'      => E_CORE_WARNING,
        'E_COMPILE_ERROR'     => E_COMPILE_ERROR,
        'E_COMPILE_WARNING'   => E_COMPILE_WARNING,
        'E_USER_ERROR'        => E_USER_ERROR,
        'E_USER_WARNING'      => E_USER_WARNING,
        'E_USER_NOTICE'       => E_USER_NOTICE,
        'E_STRICT'            => defined('E_STRICT') ? E_STRICT : 0,
        'E_RECOVERABLE_ERROR' => defined('E_RECOVERABLE_ERROR') ? E_RECOVERABLE_ERROR : 0,
        'E_DEPRECATED'        => defined('E_DEPRECATED') ? E_DEPRECATED : 0,
        'E_USER_DEPRECATED'   => defined('E_USER_DEPRECATED') ? E_USER_DEPRECATED : 0,
        'E_ALL'               => E_ALL,
    ];
    $level = error_reporting();
    foreach ($E_ERROR_CONSTANTS as $name => $value) {
        if ($value !== 0 && ($level & $value)) {
            return $name;
        }
    }
    return $level.' nicht parsebar';
}

if (!function_exists('is_countable')) {
    function is_countable($var) {
        return (is_array($var) || $var instanceof Countable);
    }
}
register_shutdown_function( "check_for_fatal" );
set_error_handler( "log_error",E_ERROR );
set_exception_handler( "log_exception_handler" );
ini_set( "display_errors", "0" );
if(!is_file(DIR_FS_CATALOG.'lang/'.yes_get_language_folder().'/admin/uebergang_translation.php')){
    die('uebergang_translation.php fuer '.yes_get_language_folder().' fehlt');
}
require_once(DIR_FS_CATALOG.'lang/'.yes_get_language_folder().'/admin/uebergang_translation.php');

$used_lang = yes_get_language_folder();


function yes_date_short($dateString, $show_time = false):string{
    $date_type = gettype($dateString);
    $locale_src = yes_get_language_folder();
    $time_formatter = ($show_time === true) ? IntlDateFormatter::MEDIUM : IntlDateFormatter::NONE;
    $locale = ($locale_src == 'german') ? 'de_DE' : 'en_US';
    $formatter = new IntlDateFormatter(
        $locale, 
        IntlDateFormatter::SHORT, 
        $time_formatter,
        NULL,
        NULL
    );
    switch($date_type){
        case 'string':
            // Überprüfen auf ungültige oder leere Eingaben
            if (empty($dateString) || $dateString === '0000-00-00 00:00:00' || $dateString === '0000-00-00' || !is_string($dateString)) {
                return '';
            }
            // Versuche den DateTime-Objekt aus verschiedenen ISO-Formaten zu erstellen
            try {
                // Versuche, die Eingabe als Datum zu parsen
                $date = new DateTime($dateString);
            } catch (Exception $e) {
                // Falls das Datum ungültig ist, gib einen leeren String zurück
                return '';
            }

            // Formatiere das Datum gemäß dem Locale
            return $formatter->format($date);
            break;
        case 'object':
            return $formatter->format($dateString);
            break;
    }
    return '';
}

function isStringAValidDate(string $date, string $format = 'Y-m-d'): bool{
    $dt = DateTimeImmutable::createFromFormat($format, $date);
    return $dt && $dt->format($format) === $date && empty(DateTimeImmutable::getLastErrors()['warning_count']) && empty(DateTimeImmutable::getLastErrors()['error_count']);
}

function yes_getIntFromRequest( string $request_param, int $request_mode = INPUT_GET ){
    $check = filter_input($request_mode, $request_param, FILTER_VALIDATE_INT);
    if ($check !== false && $check !== null) {
        return $check;
    }
    return 0;
}

function yes_get_countries_iso_code_2_from_countries_name(string $country_name):string{
    $iso2 = yes_query(
        "SELECT countries_iso_code_2 FROM countries WHERE countries_name=:cname",[
            'cname'=>$country_name
        ],true
    );
    return $iso2['countries_iso_code_2']??'';
}

class yescache_helper{
    public static function cache_get_generation(
        \Phpfastcache\Core\Pool\ExtendedCacheItemPoolInterface $cache,
        string $group
    ): int {
        $gkey = "gen-{$group}";
        $item = $cache->getItem($gkey);
        $gen  = (int) ($item->isHit() ? $item->get() : 1);
        return max(1, $gen);
    }

    public static function cache_bump_generation(
        \Phpfastcache\Core\Pool\ExtendedCacheItemPoolInterface $cache,
        string $group
    ): int {
        $gkey = "gen-{$group}";
        $item = $cache->getItem($gkey);
        $gen  = (int) ($item->isHit() ? $item->get() : 1);
        $gen++;
        $item->set($gen)->expiresAfter(7*24*3600); // z.B. 7 Tage
        $cache->save($item);
        return $gen;
    }

    public static function cache_key(
        \Phpfastcache\Core\Pool\ExtendedCacheItemPoolInterface $cache,
        string $group,
        string $localKey // z. B. "c{$categories_id}-l{$language}"
    ): string {
        $gen = self::cache_get_generation($cache, $group);
        // robuster, dateisystemfreundlicher Key:
        return "{$group}-v{$gen}-" . md5($localKey);
    }    
}

/**
 * Verzeichnisname fuer aktuelle Sprache ermitteln
 * ist _SESSION['language'] nicht gesetzt, dann wird auf DEFAULT_LANGUAGE
 * zurueckgegriffen und anhand des Codes (de, en ...) aus den Languages das
 * Verzeichnis zurückgegeben.
 * Ist DEFAULT_LANGUAGE nicht gesetzt, geben wir german zurueck
 * @return string
 */
function yes_get_language_folder(){
    if(!isset($_SESSION['language']) or empty($_SESSION['language'])){
        if(!defined('DEFAULT_LANGUAGE') or empty(constant('DEFAULT_LANGUAGE'))){
            return 'german';
        }
        $languages = \YES4Trade\Model\languages::get_list();
        foreach($languages as $lang){
            if($lang['code'] == constant('DEFAULT_LANGUAGE')){
                return $lang['directory'];
            }
        }
    }
    return $_SESSION['language'];
}

function yes_get_language_id(){
    $current_directory = yes_get_language_folder();
    $languages = \YES4Trade\Model\languages::get_list();
    foreach($languages as $lang){
        if($lang['directory'] == $current_directory){
            return intval($lang['languages_id']);
        }
    }
    return 2; // fallback german
}