<?php
/* -----------------------------------------------------------------------------------------
   $Id: ot_cod_fee.php,v 1.5 2013/11/13 09:27:27 cvs Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(ot_cod_fee.php,v 1.02 2003/02/24); www.oscommerce.com
   (C) 2001 - 2003 TheMedia, Dipl.-Ing Thomas Pl�nkers ; http://www.themedia.at & http://www.oscommerce.at

   Released under the GNU General Public License
   -----------------------------------------------------------------------------------------
   Third Party contributions:

   Adapted for xtcommerce 2003/09/30 by Benax (axel.benkert@online-power.de)

   Credit Class/Gift Vouchers/Discount Coupons (Version 5.10)
   http://www.oscommerce.com/community/contributions,282
   Copyright (c) Strider | Strider@oscworks.com
   Copyright (c  Nick Stanko of UkiDev.com, nick@ukidev.com
   Copyright (c) Andre ambidex@gmx.net
   Copyright (c) 2001,2002 Ian C Wilson http://www.phesis.org

   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/


  class ot_cod_fee {
    var $title, $output, $code, $enabled, $description, $sort_order, $Price;

    function __construct($price=0) {
        $this->code = 'ot_cod_fee';
        $this->title = MODULE_ORDER_TOTAL_COD_TITLE;
        $this->description = MODULE_ORDER_TOTAL_COD_DESCRIPTION;
        $this->enabled = ((defined('MODULE_ORDER_TOTAL_COD_STATUS') and MODULE_ORDER_TOTAL_COD_STATUS == 'true') ? true : false);
        $this->sort_order = (defined('MODULE_ORDER_TOTAL_COD_STATUS'))?MODULE_ORDER_TOTAL_COD_SORT_ORDER:0;
        $this->Price=$price;
        $this->output = array();
    }

    function process() {
      global $order, $currencies, $cod_cost, $cod_country, $shipping;
      if (MODULE_ORDER_TOTAL_COD_STATUS == 'true') {

        //Will become true, if cod can be processed.
        $cod_country = false;
        //check if payment method is cod. If yes, check if cod is possible.
        if (isset($_SESSION['payment']) and ( $_SESSION['payment'] == 'cod' or $_SESSION['payment'] == 'yes_cod') ){
          //process installed shipping modules
          if ($_SESSION['shipping']['id'] == 'flat_flat') $cod_zones = split("[:,]", MODULE_ORDER_TOTAL_COD_FEE_FLAT);
          if ($_SESSION['shipping']['id'] == 'item_item') $cod_zones = split("[:,]", MODULE_ORDER_TOTAL_COD_FEE_ITEM);
          if ($_SESSION['shipping']['id'] == 'table_table') $cod_zones = split("[:,]", MODULE_ORDER_TOTAL_COD_FEE_TABLE);
          if ($_SESSION['shipping']['id'] == 'zones_zones') $cod_zones = split("[:,]", MODULE_ORDER_TOTAL_COD_FEE_ZONES);
          if ($_SESSION['shipping']['id'] == 'ap_ap') $cod_zones = split("[:,]", MODULE_ORDER_TOTAL_COD_FEE_AP);
          if ($_SESSION['shipping']['id'] == 'dp_dp') $cod_zones = split("[:,]", MODULE_ORDER_TOTAL_COD_FEE_DP);

                    // module chp
          if ($_SESSION['shipping']['id'] == 'chp_ECO') $cod_zones = split("[:,]", MODULE_ORDER_TOTAL_COD_FEE_CHP);
          if ($_SESSION['shipping']['id'] == 'chp_PRI') $cod_zones = split("[:,]", MODULE_ORDER_TOTAL_COD_FEE_CHP);
          if ($_SESSION['shipping']['id'] == 'chp_URG') $cod_zones = split("[:,]", MODULE_ORDER_TOTAL_COD_FEE_CHP);

          // module chronopost
          if ($_SESSION['shipping']['id'] == 'chronopost_chronopost') $cod_zones = split("[:,]", MODULE_ORDER_TOTAL_COD_FEE_CHRONOPOST);

          // module DHL
          if ($_SESSION['shipping']['id'] == 'dhl_ECX') $cod_zones = split("[:,]", MODULE_ORDER_TOTAL_COD_FEE_DHL);
          if ($_SESSION['shipping']['id'] == 'dhl_DOX') $cod_zones = split("[:,]", MODULE_ORDER_TOTAL_COD_FEE_DHL);
          if ($_SESSION['shipping']['id'] == 'dhl_SDX') $cod_zones = split("[:,]", MODULE_ORDER_TOTAL_COD_FEE_DHL);
          if ($_SESSION['shipping']['id'] == 'dhl_MDX') $cod_zones = split("[:,]", MODULE_ORDER_TOTAL_COD_FEE_DHL);
          if ($_SESSION['shipping']['id'] == 'dhl_WPX') $cod_zones = split("[:,]", MODULE_ORDER_TOTAL_COD_FEE_DHL);

          // Free Shipping
          if ($_SESSION['shipping']['id'] == 'free_free') $cod_zones = split("[:,]", MODULE_ORDER_TOTAL_COD_FEE_FREE);

//	  if ($_SESSION['shipping']['id'] == 'freeamount_freeamount') $cod_zones = split("[:,]", MODULE_SHIPPING_FREEAMOUNT_ALLOWED);

	  if ($_SESSION['shipping']['id'] != 'yes_yes' and $_SESSION['shipping']['id'] != 'freeamount_freeamount'){
		for ($i = 0; $i < count($cod_zones); $i++) {
			if ($cod_zones[$i] == $order->billing['country']['iso_code_2']) {
				$cod_cost = $cod_zones[$i + 1];
				$cod_country = true;
				//print('match' . $cod_zones[$i] . ': ' . $cod_cost);
				break;
			} elseif ($cod_zones[$i] == '00') {
				$cod_cost = $cod_zones[$i + 1];
				$cod_country = true;
				//print('match' . $i . ': ' . $cod_cost);
				break;
			} else {
				//print('no match');
			}
			$i++;
		}
	  }else{
		$cod_country = true;
		$cod_cost = $GLOBALS['yes_cod']->fee;
	  }
     } else {
            //COD selected, but no shipping module which offers COD
     }

        if ($cod_country) {
                // EU-OSS 2021/07
                // Nicht mehr die Modul Konfiguration Taxclass verwenden
                // sondern shipping 
                $tax_class_id = $order->get_shipping_tax_class();
                
                // BOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
                /*if(yes_eu_oss_use_country_handling($order->delivery['country']['id'])){
                    $cod_tax = xtc_get_tax_rate($tax_class_id, $order->delivery['country']['id'], $order->delivery['zone_id']);
                    $cod_tax_description = xtc_get_tax_description($tax_class_id, $order->delivery['country']['id'], $order->delivery['zone_id']);
                }else{
                    $cod_tax = xtc_get_tax_rate($tax_class_id, STORE_COUNTRY, 0);
                    $cod_tax_description = xtc_get_tax_description($tax_class_id, STORE_COUNTRY, 0);
                }*/
                // EOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
                
                // BUGF_CH_OSS
                $cod_tax = xtc_get_tax_rate($tax_class_id, $order->delivery['country']['id'], $order->delivery['zone_id']);
                $cod_tax_description = xtc_get_tax_description($tax_class_id, $order->delivery['country']['id'], $order->delivery['zone_id']);
                
		if ($_SESSION['customers_status']['customers_status_show_price_tax'] == 1) {

			$order->info['tax'] += xtc_add_tax($cod_cost, $cod_tax)-$cod_cost;
			$order->info['tax_groups'][TAX_ADD_TAX . "$cod_tax_description"] += xtc_add_tax($cod_cost, $cod_tax)-$cod_cost;
			$order->info['total'] += $cod_cost + (xtc_add_tax($cod_cost, $cod_tax)-$cod_cost);
			$cod_cost_value= xtc_add_tax($cod_cost, $cod_tax);
			$cod_cost= $this->Price->xtcFormat($cod_cost_value,true);
		}
		if ($_SESSION['customers_status']['customers_status_show_price_tax'] == 0 && $_SESSION['customers_status']['customers_status_add_tax_ot'] == 1) {
			$order->info['tax'] += xtc_add_tax($cod_cost, $cod_tax)-$cod_cost;
			$order->info['tax_groups'][TAX_NO_TAX . "$cod_tax_description"] += xtc_add_tax($cod_cost, $cod_tax)-$cod_cost;
			$cod_cost_value=$cod_cost;
			$cod_cost= $this->Price->xtcFormat($cod_cost,true);
			$order->info['subtotal'] += $cod_cost_value;
			$order->info['total'] += $cod_cost_value;
		}
		if (!$cod_cost_value) {
			$cod_cost_value=$cod_cost;
			$cod_cost= $this->Price->xtcFormat($cod_cost,true);
			$order->info['total'] += $cod_cost_value;
		}
		$this->output[] = array('title' => $this->title . ':',
					'text' => $cod_cost,
					'value' => $cod_cost_value);
        } else {
//Following code should be improved if we can't get the shipping modules disabled, who don't allow COD
// as well as countries who do not have cod
//          $this->output[] = array('title' => $this->title . ':',
//                                  'text' => 'No COD for this module.',
//                                  'value' => '');
        }
      }
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_ORDER_TOTAL_COD_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function keys() {
      return array('MODULE_ORDER_TOTAL_COD_STATUS', 'MODULE_ORDER_TOTAL_COD_SORT_ORDER', 'MODULE_ORDER_TOTAL_COD_FEE_FLAT', 'MODULE_ORDER_TOTAL_COD_FEE_ITEM', 'MODULE_ORDER_TOTAL_COD_FEE_TABLE','MODULE_ORDER_TOTAL_COD_FEE_CHRONOPOST','MODULE_ORDER_TOTAL_COD_FEE_DHL','MODULE_ORDER_TOTAL_COD_FEE_CHP', 'MODULE_ORDER_TOTAL_COD_FEE_ZONES', 'MODULE_ORDER_TOTAL_COD_FEE_AP', 'MODULE_ORDER_TOTAL_COD_FEE_DP', 'MODULE_ORDER_TOTAL_COD_FEE_FREE', 'MODULE_ORDER_TOTAL_COD_TAX_CLASS');
    }

    function install() {
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_ORDER_TOTAL_COD_STATUS', 'true', '6', '0', 'xtc_cfg_select_option(array(\'true\', \'false\'), ', now())");

      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_ORDER_TOTAL_COD_SORT_ORDER', '35', '6', '0', now())");

      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_ORDER_TOTAL_COD_FEE_FLAT', 'AT:3.00,DE:3.58,00:9.99', '6', '0', now())");

      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_ORDER_TOTAL_COD_FEE_ITEM', 'AT:3.00,DE:3.58,00:9.99', '6', '0', now())");

      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_ORDER_TOTAL_COD_FEE_TABLE', 'AT:3.00,DE:3.58,00:9.99', '6', '0', now())");

      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_ORDER_TOTAL_COD_FEE_ZONES', 'CA:4.50,US:3.00,00:9.99', '6', '0', now())");

      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_ORDER_TOTAL_COD_FEE_AP', 'AT:3.63,00:9.99', '6', '0', now())");

      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_ORDER_TOTAL_COD_FEE_DP', 'DE:4.00,00:9.99', '6', '0', now())");

      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_ORDER_TOTAL_COD_FEE_CHP', 'CH:4.00,00:9.99', '6', '0', now())");

      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_ORDER_TOTAL_COD_FEE_CHRONOPOST', 'FR:4.00,00:9.99', '6', '0', now())");

      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_ORDER_TOTAL_COD_FEE_DHL', 'AT:3.00,DE:3.58,00:9.99', '6', '0', now())");

      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_ORDER_TOTAL_COD_FEE_FREE', 'AT:3.00,DE:3.58,00:9.99', '6', '0', now())");

      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, use_function, set_function, date_added) values ('MODULE_ORDER_TOTAL_COD_TAX_CLASS', '0', '6', '0', 'xtc_get_tax_class_title', 'xtc_cfg_pull_down_tax_classes(', now())");
    }

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }
  }
