<?php
class bar_kasse {
    var $code, $title, $description, $enabled;

    function __construct() {
      global $order;

      $this->code = 'bar_kasse';
      $this->title = MODULE_PAYMENT_BAR_KASSE_TEXT_TITLE;
      $this->description = MODULE_PAYMENT_BAR_KASSE_TEXT_DESCRIPTION;
      $this->sort_order = (defined('MODULE_PAYMENT_BAR_KASSE_SORT_ORDER')) ? MODULE_PAYMENT_BAR_KASSE_SORT_ORDER:0;
      $this->enabled = ((defined('MODULE_PAYMENT_BAR_KASSE_STATUS') and MODULE_PAYMENT_BAR_KASSE_STATUS == 'True') ? true : false);
      if($this->enabled === true){
        if ((int)MODULE_PAYMENT_BAR_KASSE_ORDER_STATUS_ID > 0) {
          $this->order_status = MODULE_PAYMENT_BAR_KASSE_ORDER_STATUS_ID;
        }
        $this->email_footer = MODULE_PAYMENT_BAR_KASSE_TEXT_EMAIL_FOOTER;
      }

      if (is_object($order)) $this->update_status();
    
    }


    function update_status() {
      global $order;

      if ( ($this->enabled == true) && ((int)MODULE_PAYMENT_BAR_KASSE_ZONE > 0) ) {
        $check_flag = \YES4Trade\Model\zones_to_geo_zones::is_module_payment_zone_valid(
            intval(MODULE_PAYMENT_BAR_KASSE_ZONE),
            intval($order->billing['country']['id']),
            intval($order->billing['zone_id'])
        );
        if ($check_flag == false) {
          $this->enabled = false;
        }
      }
    }

    function javascript_validation() {
      return false;
    }

    function selection() {
      return array('id' => $this->code,
                   'module' => $this->title);
    }

    function pre_confirmation_check() {
      return false;
    }

    function confirmation() {
      return array('title' => MODULE_PAYMENT_BAR_KASSE_TEXT_DESCRIPTION);
    }

    function process_button() {
      return false;
    }

    function before_process() {
      return false;
    }

    function after_process() {
      return false;
    }

    function get_error() {
      return false;
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_BAR_KASSE_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_BAR_KASSE_STATUS', 'True', '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now());");
	  xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_BAR_KASSE_ALLOWED', '',   '6', '0', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_BAR_KASSE_PAYTO', '', '6', '1', now());");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_BAR_KASSE_SORT_ORDER', '0', '6', '0', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, use_function, set_function, date_added) values ('MODULE_PAYMENT_BAR_KASSE_ZONE', '0',  '6', '2', 'xtc_get_zone_class_title', 'xtc_cfg_pull_down_zone_classes(', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, use_function, date_added) values ('MODULE_PAYMENT_BAR_KASSE_ORDER_STATUS_ID', '0', '6', '0', 'xtc_cfg_pull_down_order_statuses(', 'xtc_get_order_status_name', now())");
    }

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_PAYMENT_BAR_KASSE_STATUS','MODULE_PAYMENT_BAR_KASSE_ALLOWED', 'MODULE_PAYMENT_BAR_KASSE_ZONE', 'MODULE_PAYMENT_BAR_KASSE_ORDER_STATUS_ID', 'MODULE_PAYMENT_BAR_KASSE_SORT_ORDER', 'MODULE_PAYMENT_BAR_KASSE_PAYTO');
    }
}
