<?php
/* includes/modules/payment/paypal_ppp.php
.---------------------------------------------------------------------------.
|    Software: PayPal-Plus-Module                                           |
|     Version: 0.11beta                                                     |
|        Date: 2016-02-09                                                   |
| Description: basic payment-file                                           |
|     Contact: info@andreas-guder.de                                        |
| ------------------------------------------------------------------------- |
|      Author: Andreas Guder                                                |
|     Contact: info@andreas-guder.de                                        |
| Copyright (c) 2015, Andreas Guder.                                        |
| ------------------------------------------------------------------------- |
|     License:  GNU Public License V2.0                                     |
|               http://www.gnu.org/licenses/gpl-2.0.html                    |
'--------------------------------------------------------------------------'
*/
//require_once(DIR_FS_CATALOG.'includes/classes/paypal_ppp_rest.class.php');
class paypal_ppp {
	var $code, $title, $description, $enabled;

	function paypal_ppp() {
		global $order;

		$this->code = 'paypal_ppp';
		$this->title = MODULE_PAYMENT_PAYPAL_PPP_TEXT_TITLE;
		$this->description = MODULE_PAYMENT_PAYPAL_PPP_TEXT_DESCRIPTION;
		$this->sort_order = MODULE_PAYMENT_PAYPAL_PPP_SORT_ORDER;
		$this->enabled = ((MODULE_PAYMENT_PAYPAL_PPP_STATUS == 'True') ? true : false);
		$this->info = MODULE_PAYMENT_PAYPAL_PPP_USE_LANG_TEXT == 'True' ? MODULE_PAYMENT_PAYPAL_PPP_TEXT_INFO : MODULE_PAYMENT_PAYPAL_PPP_INTROTEXT;
    $this->info_title = MODULE_PAYMENT_PAYPAL_PPP_USE_LANG_TEXT == 'True' ? MODULE_PAYMENT_PAYPAL_PPP_TEXT_INFO_TITLE : MODULE_PAYMENT_PAYPAL_PPP_INTROTITLE;
    $this->ot_ignore = array('ot_total','ot_subtotal','ot_shipping','ot_subtotal_no_tax','ot_tax');
    $this->ot_handling_fee = array('ot_sperrgut');

		if (is_object($order))
			$this->update_status();
	}

	function update_status() {
		global $order;

    $check_flag = true;
    if (MODULE_PAYMENT_PAYPAL_PPP_TEST == 'True' && $_SESSION['customers_status']['customers_status_id'] != 0)
      $check_flag = false;

    if ($check_flag == false) {
      $this->enabled = false;
    }

	}

	function javascript_validation() {
		return false;
	}

	function selection() {
    $info = $this->info.'<noscript><input type="hidden" name="ppp_noscript" value="1" /></noscript>';
		return array ('id' => $this->code, 'module' => $this->info_title, 'description' => $info);
	}

	function pre_confirmation_check($no_address = false) {
    global $order;
    global $order_total_modules;

    /* 
      wird in der checkout_confirmation aufgerufen. (oder manuell in checkout_paypal_ppp.php und paypal_ppp_ajax_request.php)
      wenn javascript activ, dann umleiten auf interne ppp-checkout-Seite
      wenn javascript nicht aktiv, dann umleiten auf express-checkout-Seite
      aber nur, wenn Zahlungsart gendert werden soll, oder der Prozess das erste Mal durchlaufen wird
      wie erkenne ich, ob die Zahlungsart gendert werden soll?
    */
    if (!isset($_GET['ppp_confirm'])){
      $return_result = false;
      if (strpos($_SERVER['PHP_SELF'], 'checkout_paypal_ppp.php') || strpos($_SERVER['PHP_SELF'], 'checkout_paypal_plus.php'))
        $return_result = true;
      if (strpos($_SERVER['PHP_SELF'], 'paypal_ppp_ajax_requests.php') || strpos($_SERVER['PHP_SELF'], 'paypal_plus_ajax_requests.php'))
        $return_result = true;
      
      // an dieser Stelle bentige ich den Gesamtwert der Bestellung
      // Stock Check
	// Stock Check
	$any_out_of_stock = false;
	$any_disabled = false;
	if (STOCK_CHECK == 'true' or STOCK_ALLOW_CHECKOUT != 'true') {
		for ($i=0, $n=sizeof($order->products); $i<$n; $i++) {
			$SQ = new products_quantity($order->products[$i]['id']);
			$qty_total = (defined('STOCK_CHECK_AVAILABLE_METHOD') and STOCK_CHECK_AVAILABLE_METHOD == 'True') ? $SQ->get_available1_qty() : $SQ->get_available2_qty();
			// QTY und PRODUCTS_STATUS PRUEFEN
			if($qty_total<$order->products[$i]['qty']){
				$any_out_of_stock = 1;
			}
			if(!$SQ->get_products_status() ){
				$any_disabled = 1;
			}
		}
		// Out of Stock
		if (STOCK_CHECK == 'true' and $any_out_of_stock == true) {
			xtc_redirect(xtc_href_link(FILENAME_SHOPPING_CART));
		}
		if ( STOCK_ALLOW_CHECKOUT != 'true' and $any_disabled ) {
			xtc_redirect(xtc_href_link(FILENAME_SHOPPING_CART));
		}
	}
	// EOF Stock Check
      
      $ppp_rest = new PAYPAL_PPP_REST();
      if (!$ppp_rest && !$return_result)
        xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, 'error_message=' . urlencode('Keine Verbindung zu PayPal Plus'), 'SSL'));
      elseif (!$ppp_rest && $return_result)
        die('Keine Verbindung zu PayPal Plus');

        
      // bereite die Daten vor
      $total_array = $order_total_modules->process();
      
      $payment = array(
        'intent'  => 'sale',
        'experience_profile_id' => $ppp_rest->get_experience_profile_id(),
        'payer' => array(
          'payment_method'=>'paypal'
        ),
        'redirect_urls' => array(
          'return_url'  => html_entity_decode(xtc_href_link(FILENAME_CHECKOUT_CONFIRMATION, 'ppp_confirm=1', 'SSL')),
          'cancel_url'  => html_entity_decode(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, 'error_message=' . urlencode(ERROR_NO_PAYMENT_MODULE_SELECTED), 'SSL')),
        ),
        'transactions'  => array(
          0 => array(
            //'custom'  => // hier sollte die order_id stehen
            'item_list' => array(
              'items' => array() // wird spter gefllt
            ),
            'amount' => array() // wird spter gefllt
          )
        )
      );
      if (!$no_address)
      {
        // check for state!
        if ($order->delivery['country_id'] != 81)
        {
          if (empty($order->delivery['state']))
          {
            $tmp = xtc_db_fetch_array(xtc_db_query("SELECT COUNT(*) AS cont FROM `".TABLE_ZONES."` WHERE `zone_country_id`=".$order->delivery['country_id']));
            if ($tmp['cont'] > 0)
            {
              xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYPAL_PPP, 'req=express', 'SSL'));
            }
          }
        }
        
        $cCode = $ppp_rest->get_store_country_code($order->delivery['country_id']);
        $payment['transactions'][0]['item_list']['shipping_address'] = array(
          'recipient_name'  => empty($order->delivery['firstname']) ? $order->delivery['lastname'] : $order->delivery['firstname'].' '.$order->delivery['lastname'],
          'line1'           => $order->delivery['street_address'],
          'city'            => $order->delivery['city'],
          'postal_code'     => $order->delivery['postcode'],
          'country_code'    => $cCode,
          'state'           => empty($order->delivery['state']) ? '' : $order->delivery['state']
        );
        $_SESSION['delivery_zone'] = $cCode;
      }
      if ($_SESSION['shipping']['id'] != 'free_free')
      {
        $module = substr($_SESSION['shipping']['id'], 0, strpos($_SESSION['shipping']['id'], '_'));
        if(!isset($GLOBALS[$module]) || !is_object($GLOBALS[$module]))
        {
          require_once DIR_WS_CLASSES.'shipping.php';
          $shipping_modules = new shipping;
          $ot_shipping = new ot_shipping();
          $ot_shipping->process();
        }
      }
      
      $aTData = $this->get_transaction_data_from_ot_total($order, $total_array);
      $payment['transactions'][0]['item_list']['items'] = $aTData['items'];
      $payment['transactions'][0]['amount'] = $aTData['amount'];
      
      $insert_action = true;
      if (isset($_SESSION['agi_ppp']['ppp_payment_id']))
      {
        // items knnen nicht gendert/entfernt werden daher muss das Payment gelscht und neu eingetragen werden
        $ppp_rest->delete_paypal_payment_ressource($_SESSION['agi_ppp']['ppp_payment_id']);
        $ppp_rest->prepare_request('v1/payments/payment', 'POST', $payment);
      }
      else
      {
        // Eine neue Paypal-Zahlung wird initiiert
        $ppp_rest->prepare_request('v1/payments/payment', 'POST', $payment);
      }
      
      // Kann der Kontakt zu ppp hergestellt werden?
      // --> Initiere paypal Zahlung
      // confirm-url = checkout_confirmation.php?ppp_confirm=true
      $ppp_rest->add_custom_header('Authorization: Bearer '.$ppp_rest->get_api_access_token());
      $result = $ppp_rest->execute();
      if (is_array($result))
      {
        if ($insert_action && ((int)$result['info']['http_code'] == 200 || (int)$result['info']['http_code'] == 201))
        {
          // der insert-befehl wurde erfolgreich ausgefhrt
          if ($return_result){
            return $result;
	}
          $body = json_decode($result['body']);
          $approval_url = '';
          foreach ($body->links as $row)
          {
            if ($row->rel == 'approval_url')
            {
              $approval_url = $row->href;
              break;
            }
          }
          $_SESSION['agi_ppp']['ppp_approval_url'] = $approval_url; // stammt vom Anlegen der Zahlung
          $_SESSION['agi_ppp']['ppp_payment_id'] = $body->id;

          if (isset($_POST['ppp_noscript']))
          {
            // leite weiter auf approval-url, da Javascript nicht aktiv
            // nach erfolgreicher Eingabe wird auf die checkout_confirmation umgeleitet
            header('Location: '.$_SESSION['agi_ppp']['ppp_approval_url']);
            exit;
          }
          else
          {
            // leite weiter auf interne ppp-Seite
            xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYPAL_PPP, '', 'SSL'));
            // nach erfolgreicher Eingabe wird auf die checkout_confirmation umgeleitet
          }
        }
        elseif (!$insert_action && (int)$result['info']['http_code'] == 204)
        {
          // der update-befehl wurde erfolgreich ausgefhrt
          /* es muss nichts gemacht werden 
          $body = json_decode($result['body']);
          echo 'update';
          var_dump($body);
          exit;
          */
          if ($return_result)
            return $result;
        }
        else
        {
          // ein befehl wurde nicht erfolgreich ausgefhrt
          if ($return_result)
          {
            die($insert_action ? 'PPP INSERT failed: Paypal-Code '.$result['info']['http_code'].': '.$ppp_rest->parse_error_response_body($result['body']) : 'PPP UPDATE failed: Paypal-Code '.$result['info']['http_code'].': '.$ppp_rest->parse_error_response_body($result['body']));
          }
          if ($insert_action)
            xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, 'error_message=' . urlencode('PPP INSERT failed: Paypal-Code '.$result['info']['http_code'].': '.$ppp_rest->parse_error_response_body($result['body'])), 'SSL'));
          else
            xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, 'error_message=' . urlencode('PPP UPDATE failed: Paypal-Code '.$result['info']['http_code'].': '.$ppp_rest->parse_error_response_body($result['body'])), 'SSL'));
        }
      }else{
        // nein, kein Kontakt zu ppp, redirect zu checkout-payment mit Hinweis auf Unmglichkeit 
        if ($return_result)
          die(ERROR_NO_PAYMENT_MODULE_SELECTED);
        else
          xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, 'error_message=' . urlencode(ERROR_NO_PAYMENT_MODULE_SELECTED), 'SSL'));
      }
      $order = new order(); // zur sicherheit, wenn doch die confirmation-page gezeigt wird
    }
    elseif (isset($_GET['ppp_confirm']))
    {
      /** 20151028 */
      $_SESSION['agi_ppp']['payment_type'] = '';
      $_SESSION['agi_ppp']['payment_instruction'] = '';
      /* 20151028 **/
      if (empty($_GET['PayerID']) || empty($_GET['paymentId']) || empty($_SESSION['agi_ppp']['ppp_payment_id']) || $_GET['paymentId'] != $_SESSION['agi_ppp']['ppp_payment_id']){
        xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, 'error_message=' . urlencode('PPP Payment-Resource unstimmig'), 'SSL'));
      }else{
        $_SESSION['agi_ppp']['payer_id'] = $_GET['PayerID'];
        $_SESSION['agi_ppp']['patch_shipping'] = false;
        
        // get payment-data from paypal to create cusomers-account and/or check payment-type
        $ppp_rest = new PAYPAL_PPP_REST();
        if (!$ppp_rest && !$return_result)
          xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, 'error_message=' . urlencode('Keine Verbindung zu PayPal Plus'), 'SSL'));
        elseif (!$ppp_rest && $return_result)
          die('Keine Verbindung zu PayPal Plus');
        $ppp_rest->prepare_request('v1/payments/payment/'.$_SESSION['agi_ppp']['ppp_payment_id'], 'GET');
        $ppp_rest->add_custom_header('Authorization: Bearer '.$ppp_rest->get_api_access_token());
        $result = $ppp_rest->execute();
        if (is_array($result))
        {
          if ((int)$result['info']['http_code'] == 200 || (int)$result['info']['http_code'] == 201)
          {
            $body = json_decode($result['body']);
            if (empty($_SESSION['customer_id']))
            {
              $aCustomersData = array(
                'email_address' => $body->payer->payer_info->email,
                'firstname'     => $body->payer->payer_info->first_name,
                'lastname'      => $body->payer->payer_info->last_name,
                'phone'         => '',
                'tax_id'        => '',
                'date_of_birth' => ''
              );
              if (isset($body->payer->payer_info->phone) && !empty($body->payer->payer_info->phone) && strtolower($body->payer->payer_info->phone) != 'empty')
                $aCustomersData['phone'] = $body->payer->payer_info->phone;
              if (isset($body->payer->payer_info->tax_id) && !empty($body->payer->payer_info->tax_id) && strtolower($body->payer->payer_info->tax_id) != 'empty')
                $aCustomersData['tax_id'] = $body->payer->payer_info->tax_id;
              
              $tmp = explode(' ', $body->payer->payer_info->shipping_address->recipient_name);
              if (count($tmp) > 1)
              {
                $tFirstName = array_shift($tmp);
                $tLastName = implode(' ', $tmp);
              }
              else
              {
                $tFirstName = '';
                $tLastName = $tmp[0];
              }
              $aShippingAddress = array(
                'firstname'     => $tFirstName,
                'lastname'      => $tLastName,
                'street'        => $body->payer->payer_info->shipping_address->line1,
                'city'          => $body->payer->payer_info->shipping_address->city,
                'state'         => '',
                'suburb'        => '',
                'postal_code'   => $body->payer->payer_info->shipping_address->postal_code,
                'country_code'  => $body->payer->payer_info->shipping_address->country_code
              );
              if (isset($body->payer->payer_info->shipping_address->state) && !empty($body->payer->payer_info->shipping_address->state) && strtolower($body->payer->payer_info->shipping_address->state) != 'empty')
                $aShippingAddress['state'] = $body->payer->payer_info->shipping_address->state;
              if (isset($body->payer->payer_info->shipping_address->line2) && !empty($body->payer->payer_info->shipping_address->line2) && strtolower($body->payer->payer_info->shipping_address->line2) != 'empty')
                $aShippingAddress['suburb'] = $body->payer->payer_info->shipping_address->line2;
              if (isset($body->payer->payer_info->shipping_address->phone) && !empty($body->payer->payer_info->shipping_address->phone) && strtolower($body->payer->payer_info->shipping_address->phone) != 'empty')
                if (empty($aCustomersData['phone']))
                  $aCustomersData['phone'] = $body->payer->payer_info->shipping_address->phone;
              
              // get address
              require_once(DIR_FS_CATALOG.'includes/modules/payment/paypal_ppp/hook_login_client.php');
              $_SESSION['agi_ppp']['express_checkout'] = false;
              $_SESSION['agi_ppp']['patch_shipping'] = true;
              require_once DIR_WS_CLASSES.'order.php';
              $order = new order();
              
              // is shipping-class allowed
              $total_weight = $_SESSION['cart']->show_weight();
              $total_count = $_SESSION['cart']->count_contents();

              // load all enabled shipping modules
              require_once DIR_FS_INC.'xtc_count_shipping_modules.inc.php';
              require_once DIR_WS_CLASSES.'shipping.php';
              include_once DIR_WS_LANGUAGES.$_SESSION['language'].'/modules/order_total/ot_shipping.php';
              require_once DIR_WS_MODULES.'order_total/ot_shipping.php';
              require_once DIR_FS_INC . 'xtc_calculate_tax.inc.php';
              require_once DIR_FS_INC . 'xtc_display_tax_value.inc.php';
              $shipping_modules = new shipping;
              
              if ((xtc_count_shipping_modules() > 0) || ($free_shipping == true)) 
              {
                list ($module, $method) = explode('_', $_SESSION['shipping']['id']);
                if ((isset($GLOBALS[$module]) && is_object($GLOBALS[$module]) ) || ($_SESSION['shipping']['id'] == 'free_free'))
                {
                  if ($_SESSION['shipping']['id'] != 'free_free') 
                  {
                    $quote = $shipping_modules->quote($method, $module);
                    if (empty($quote))
                    {
                      xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYPAL_PPP, 'req=express&error_message=' . urlencode(ERROR_CHECKOUT_SHIPPING_NO_MODULE), 'SSL'));
                    }
                    elseif (isset($quote['error']))
                    {
                      // Shipping method not allowed redirect to checkout_ppp
                      xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYPAL_PPP, 'req=express&error_message=' . urlencode(ERROR_CHECKOUT_SHIPPING_NO_MODULE), 'SSL'));
                    }
                    else
                    {
                      $_SESSION['shipping'] = array (
                        'id' => $module.'_'.$method, 
                        'title' => $quote[0]['module'].' ('.$quote[0]['methods'][0]['title'].')', 
                        'cost' => $quote[0]['methods'][0]['cost']
                      );
                      $order = new order();
                    }
                  }
                  elseif($_SESSION['shipping']['id'] == 'free_free' && !$free_shipping)
                  {
                    xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYPAL_PPP, 'req=express&error_message=' . urlencode(ERROR_CHECKOUT_SHIPPING_NO_MODULE), 'SSL'));
                  }
                }
              }
              else
              { 
                xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYPAL_PPP, 'req=express&error_message=' . urlencode(ERROR_CHECKOUT_SHIPPING_NO_MODULE), 'SSL'));
              }
            }
            
            /** 20151028 */
            // Ich wurde nicht weitergeleitet? Dann ist ja alles in Ordnung und ich kann prfen, ob es sich um eine Rechnungszahlung handelt.
            $payment_type = '';
            $payment_instruction = array();
            if (isset($body->payment_instruction) && !empty($body->payment_instruction))
            {
              $payment_type = $body->payment_instruction->instruction_type;
              if ($payment_type == 'PAY_UPON_INVOICE')
              {
                $payment_instruction = array(
                  'reference_number'  => $body->payment_instruction->reference_number,
                  'recipient_banking' => array(
                    'bank'    => $this->ppp_shop_decode($body->payment_instruction->recipient_banking_instruction->bank_name),
                    'holder'  => $this->ppp_shop_decode($body->payment_instruction->recipient_banking_instruction->account_holder_name),
                    'iban'    => $this->ppp_shop_decode($body->payment_instruction->recipient_banking_instruction->international_bank_account_number),
                    'bic'     => $this->ppp_shop_decode($body->payment_instruction->recipient_banking_instruction->bank_identifier_code)
                  ),
                  'payment_due_date'  => $body->payment_instruction->payment_due_date,
                  'amount'  => array(
                    'amount'  => $body->payment_instruction->amount->value,
                    'currency'=> $body->payment_instruction->amount->currency
                  )
                );
              }
              $_SESSION['agi_ppp']['payment_type'] = $payment_type;
              $_SESSION['agi_ppp']['payment_instruction'] = $payment_instruction;
            }
            /* 20151028 **/
          }
          else
          {
            if (empty($_SESSION['customer_id']))
              $msg = 'PPP Express Failed: PayPal-Code '.$result['info']['http_code'].': '.$ppp_rest->parse_error_response_body($result['body']);
            else
              $msg = 'PPP GET Failed: PayPal-Code '.$result['info']['http_code'].': '.$ppp_rest->parse_error_response_body($result['body']);
            xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, 'error_message=' . urlencode($msg), 'SSL'));
          }
        }
        else
        {
          if (empty($_SESSION['customer_id']))
            $msg = 'PPP PayPal-Express-Checkout derzeit nicht mglich';
          else
            $msg = 'PPP PayPal-Checkout derzeit nicht mglich, Paymenttype-Check fehlgeschlagen';
          xtc_redirect(xtc_href_link(FILENAME_SHOPPING_CART, 'error_message=' . urlencode($msg), 'SSL'));
        }
        
      }
		}
    return false;
	}
  
  function get_transaction_data_from_ot_total($order, $order_total)
  {
    $transaction_array = array('items'=>array(), 'amount'=>array());
    // Flle die items
    $subtotal = 0;
    foreach ($order->products as $key => $row)
    {
      if (MODULE_PAYMENT_PAYPAL_PPP_SUMMARZIE_CART != 'True')
      {
        $transaction_array['items'][] = array(
          'name'      => $row['name'],
          'price'     => number_format($row['price'],2,'.',''),
          'currency'  => $order->info['currency'],
          'quantity'  => $row['qty'],
          //'tax'       => $row['tax']
        );
      }
      $subtotal += round($row['price'], 2) * $row['qty'];
    }
    if (MODULE_PAYMENT_PAYPAL_PPP_SUMMARZIE_CART == 'True')
    {
      $transaction_array['items'][] = array(
        'name'      => MODULE_PAYMENT_PAYPAL_PPP_SUMMARZIE_CART_TEXT == '' ? STORE_NAME : MODULE_PAYMENT_PAYPAL_PPP_SUMMARZIE_CART_TEXT,
        'price'     => number_format($subtotal,2,'.',''),
        'currency'  => $order->info['currency'],
        'quantity'  => 1,
        //'tax'       => $row['tax']
      );
    }
    
    // Flle Amount und Items
    $transaction_array['amount']['details'] = array();
    $transaction_array['amount']['currency'] = $order->info['currency'];
    if ($_SESSION['customers_status']['customers_status_show_price_tax'] == 0 && $_SESSION['customers_status']['customers_status_add_tax_ot'] == 1) 
    {
      $transaction_array['amount']['details']['tax'] = number_format($order->info['tax'],2,'.','');
      $transaction_array['amount']['total'] = number_format($order->info['total']+round($order->info['tax'],2),2,'.','');
    }
    else
      $transaction_array['amount']['total'] = number_format($order->info['total'],2,'.','');
    //$subtotal -= $order->info['tax'];
    $transaction_array['amount']['details']['shipping'] = number_format(empty($order->info['shipping_cost']) ? 0 : $order->info['shipping_cost'],2,'.','');
    
    $handling_fee = 0;
    foreach ($order_total AS $row)
    {
      if ($row['value'] == 0 || in_array($row['code'], $this->ot_ignore))
        continue;
      
      if (in_array($row['code'], $this->ot_handling_fee))
      {
        $handling_fee += $row['value'];
      }
      elseif($row['code'] == 'ot_grad_order_total_discount' or $row['code'] == 'ot_gv')
      {
        $transaction_array['items'][] = array(
          'name'      => strip_tags($row['title']),
          'price'     => number_format($row['value']*-1,2,'.',''),
          'currency'  => $order->info['currency'],
          'quantity'  => 1,
          //'tax'       => $row['tax'] dont know
        );
        $subtotal -= round($row['value'], 2);
      }
      else
      {
        $transaction_array['items'][] = array(
          'name'      => strip_tags($row['title']),
          'price'     => number_format($row['value'],2,'.',''),
          'currency'  => $order->info['currency'],
          'quantity'  => 1,
          //'tax'       => $row['tax'] dont know
        );
        $subtotal += round($row['value'], 2);
      }
    }
    if ($handling_fee <> 0)
      $transaction_array['amount']['details']['handling_fee'] = number_format($handling_fee,2,'.','');
    $transaction_array['amount']['details']['subtotal'] = number_format($subtotal,2,'.','');
    
    return $transaction_array;
  }

  function ppp_shop_decode($string)
  {
    return strtolower($_SESSION['language_charset']) != 'utf-8' ? utf8_decode($string) : $string;
  }
  
	function confirmation() {
		return false;
	}

	function process_button() {
		return false;
	}

	function before_process() {
    /* 
      wird in der checkout_process aufgerufen.
      prfe nochmals, ob die Payment-Id auch angelegt ist.
      wenn nicht, muss die checkout-payment nochmals aufgerufen werden.
      
      ist die payment-id vorhanden, kann die zahlung ausgelst werden
      bei Erfolgsmeldung: fertig, lsche ppp-Session-ID
      bei Fehlermeldung: zurck auf checkout-payment, Fehlermeldung anzeigen
      
      auf der checkout-success: Wenn ppp-session-id noch vorhanden, dann lsche die Infos bei pp, da sich der Kunde fr eine andere Zahlungsart entschieden hat
    */
	$redirect_filename = (defined('USE_EASYCHECKOUT') and USE_EASYCHECKOUT == 'True') ? FILENAME_CHECKOUT_SHIPPING : FILENAME_CHECKOUT_PAYMENT;
    if (!empty($_SESSION['agi_ppp']['ppp_payment_id']) && !empty($_SESSION['agi_ppp']['payer_id']))
    {
      $ppp_rest = new PAYPAL_PPP_REST();
      if (!$ppp_rest){
        xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_CONFIRMATION, 'error_message=' . urlencode('Keine Verbindung zu PayPal Plus'), 'SSL'));
      }
      
      $ppp_rest->prepare_request('v1/payments/payment/'.$_SESSION['agi_ppp']['ppp_payment_id'], 'GET');
      $ppp_rest->add_custom_header('Authorization: Bearer '.$ppp_rest->get_api_access_token());
      $result = $ppp_rest->execute();
      if ((int)$result['info']['http_code'] != 200){
        xtc_redirect(xtc_href_link($redirect_filename, 'error_message=' . urlencode('PPP Payment-Resource nicht angelegt'), 'SSL'));
      }
    }else{
      		xtc_redirect(xtc_href_link($redirect_filename, 'error_message=' . urlencode('PPP Payment-Resource nicht angelegt'), 'SSL'));
	}
	return true;
	}

	function after_process() {
		global $insert_id;
    /* 
      wird in der checkout_process aufgerufen.
      hier wird die Zahlung ausgelst
    */
    $ppp_rest = new PAYPAL_PPP_REST();
    if ($ppp_rest)
    {
      $data = array('payer_id'=>$_SESSION['agi_ppp']['payer_id']);
      if (isset($_SESSION['agi_ppp']['patch_shipping']) && $_SESSION['agi_ppp']['patch_shipping'] === true)
      {
        require_once DIR_WS_CLASSES.'order.php';
        $order = new order($insert_id);
        $order_total = array();
        foreach ($order->totals as $row)
        {
          if ($row['class'] == 'ot_total')
            $order->info['total'] = $row['value'];
          elseif($row['class'] == 'ot_shipping')
            $order->info['shipping_cost'] = $row['value'];
          else
          {
            $order_total[] = array(
              'code'  => $row['class'],
              'value' => $row['value'],
              'title' => $row['title'],
            );
          }
        }
        
        $aTData = $this->get_transaction_data_from_ot_total($order, $order_total);
        $data['transactions'] = array(0=>array('custom'=>$insert_id));
        $data['transactions'][0]['amount'] = $aTData['amount'];
      }
      $ppp_rest->prepare_request('v1/payments/payment/'.$_SESSION['agi_ppp']['ppp_payment_id'].'/execute/', 'POST', $data);
      $ppp_rest->add_custom_header('Authorization: Bearer '.$ppp_rest->get_api_access_token());
      $result = $ppp_rest->execute();
      // ich muss eine der Ids in die Datenbank schreiben, um spter paypal-webhooks auf die richtige Bestellung zu mappen
      if (is_array($result) && ((int)$result['info']['http_code'] == 200 || (int)$result['info']['http_code'] == 201))
      {
        $body = json_decode($result['body']);
        
        $sale = array();
        foreach($body->transactions[0]->related_resources as $row)
        {
          if (is_object($row->sale))
          {
            $sale = $row->sale;
            break;
          }
        }
        $shipping_adress = array();
        if ($body->transactions[0]->item_list->shipping_address)
        {
          $sa = $body->transactions[0]->item_list->shipping_address;
          if (!empty($sa->recipient_name))
            $shipping_adress[] = $this->ppp_shop_decode($sa->recipient_name);
          if (!empty($sa->line1))
            $shipping_adress[] = $this->ppp_shop_decode($sa->line1);
          $city = '';
          if (!empty($sa->country_code))
            $city .= $sa->country_code.' - ';
          if (!empty($sa->postal_code))
            $city .= $sa->postal_code.' ';
          if (!empty($sa->city))
            $city .= $sa->city;
          if (!empty($city))
            $shipping_adress[] = $this->ppp_shop_decode($city);
        }
        /** 20151028 */
        $payment_type = '';
        $payment_instruction = array();
        if (isset($body->payment_instruction) && !empty($body->payment_instruction))
        {
          $payment_type = $body->payment_instruction->instruction_type;
          if ($payment_type == 'PAY_UPON_INVOICE')
          {
            $payment_instruction = array(
              'reference_number'  => $body->payment_instruction->reference_number,
              'recipient_banking' => array(
                'bank'    => $this->ppp_shop_decode($body->payment_instruction->recipient_banking_instruction->bank_name),
                'holder'  => $this->ppp_shop_decode($body->payment_instruction->recipient_banking_instruction->account_holder_name),
                'iban'    => $this->ppp_shop_decode($body->payment_instruction->recipient_banking_instruction->international_bank_account_number),
                'bic'     => $this->ppp_shop_decode($body->payment_instruction->recipient_banking_instruction->bank_identifier_code)
              ),
              'payment_due_date'  => $body->payment_instruction->payment_due_date,
              'amount'  => array(
                'amount'  => $body->payment_instruction->amount->value,
                'currency'=> $body->payment_instruction->amount->currency
              )
            );
            xtc_db_perform(TABLE_ORDERS, array('payment_method'=>'paypal_ppp_rechnung'), 'update', "`orders_id`=".$insert_id);
          }
        }
        /* 20151028 **/
        $sql_data = array(
          'orders_id' => $insert_id,
          'ppp_payment_id'  => $body->id,
          'ppp_sale_id'     => empty($sale) ? '' : $sale->id,
          'payer_id'        => $body->payer->payer_info->payer_id,
          'payer_email'     => $this->ppp_shop_decode($body->payer->payer_info->email),
          'payer_first_name'=> $this->ppp_shop_decode($body->payer->payer_info->first_name),
          'payer_last_name' => $this->ppp_shop_decode($body->payer->payer_info->last_name),
          'payer_shipping_address' => empty($shipping_adress) ? '' : implode(' | ', $shipping_adress),
          'payment_total'   => $body->transactions[0]->amount->total,
          'payment_total_currency'=> $body->transactions[0]->amount->currency,
          'payment_fee'     => empty($sale) ? '' : $sale->transaction_fee->value,
          'payment_fee_currency'  => empty($sale) ? '' : $sale->transaction_fee->currency,
          'payment_mode'    => empty($sale) ? '' : $sale->payment_mode,
          'mode'            => MODULE_PAYMENT_PAYPAL_PPP_MODE,
          'payment_type'    => $payment_type,
          'payment_instruction' => !empty($payment_instruction) ? serialize($payment_instruction) : ''
        );
        xtc_db_perform(TABLE_PAYPAL_PPP, $sql_data);
      }
      else
      {
        require_once(DIR_FS_INC.'xtc_php_mail.inc.php');
        xtc_php_mail(
          EMAIL_BILLING_ADDRESS,
          EMAIL_BILLING_NAME,
          EMAIL_BILLING_ADDRESS,
          STORE_NAME,
          EMAIL_BILLING_FORWARDING_STRING,
          EMAIL_BILLING_ADDRESS,
          EMAIL_BILLING_NAME,
          '',
          '',
          'PayPal-Zahlung nicht ausgefhrt',
          'Die PayPal-Zahlung zu Bestellung '.$insert_id.' konnte nicht ausgef&uuml;hrt werden, der Kunde wurde zur&uuml;ck in den Bestellprozess geleitet und gebeten, die Bestellung erneut auszuf&uuml;hren.<br />Der Fehlerstatus der Bestellung wird gesetzt.<br /><br />'.chr(10).chr(10).$ppp_rest->parse_error_response_body($result['body']),
          'Die PayPal-Zahlung zu Bestellung '.$insert_id.' konnte nicht ausgefhrt werden, der Kunde wurde zurck in den Bestellprozess geleitet und gebeten, die Bestellung erneut auszuf&uuml;hren. Der Fehlerstatus der Bestellung wird gesetzt.'.chr(10).chr(10).$ppp_rest->parse_error_response_body($result['body'])
        );
        
        $_SESSION['agi_ppp'] = array();
        xtc_db_query("UPDATE `".TABLE_ORDERS."` SET `orders_status`='".MODULE_PAYMENT_PAYPAL_PPP_ORDER_STATUS_PAYPAL_ERROR."' WHERE `orders_id`='".$insert_id."'");
        $errorMessage = 'PayPal-Zahlung konnte nicht ausgefhrt werden: '.chr(10);
        if (is_array($result))
        {
          $body = json_decode($result['body']);
          $errorMessage .= 'PPP Error'.$body->name.chr(10);
          $errorMessage .= 'PPP Message'.$body->message.chr(10);
          $errorMessage .= 'PPP DebugId'.$body->debug_id.chr(10);
        }
        $order_history = array(
          'orders_id'         => $insert_id,
          'orders_status_id'  => MODULE_PAYMENT_PAYPAL_PPP_ORDER_STATUS_PAYPAL_ERROR,
          'date_added'        => 'NOW()',
          'customer_notified' => 0,
          'comments'          => $errorMessage
        );
        /* BOF FIX check if column exists */
        $query_result = xtc_db_query("SHOW COLUMNS FROM `" . TABLE_ORDERS_STATUS_HISTORY . "`");
        $db_table_rows = array();
        while ($row = xtc_db_fetch_array($query_result))
          $db_table_rows[] = $row['Field']; 
        if (in_array('comments_sent', $db_table_rows))
          $sql_order_status['comments_sent'] = 0;
        /* EOF FIX check if column exists */
        xtc_db_perform(TABLE_ORDERS_STATUS_HISTORY, $order_history);
        xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, 'error_message=' . urlencode(MODULE_PAYMENT_PAYPAL_PPP_ORDER_STATUS_PAYPAL_ERROR_MESSAGE), 'SSL'));
        exit;
      }
      
      $_SESSION['agi_ppp'] = array();
    }
	}

	function get_error() {
		return false;
	}

	function check() {
		if (!isset ($this->_check)) {
			$check_query = xtc_db_query("select configuration_value from ".TABLE_CONFIGURATION." where configuration_key = 'MODULE_PAYMENT_PAYPAL_PPP_STATUS'");
			$this->_check = xtc_db_num_rows($check_query);
		}
		return $this->_check;
	}

	function install() {
		xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_PAYPAL_PPP_STATUS', 'True',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
		xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PAYPAL_PPP_ALLOWED', '', '6', '2', now())");
		xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PAYPAL_PPP_SORT_ORDER', '0',  '6', '3', now())");
    
		xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, use_function, date_added) values ('MODULE_PAYMENT_PAYPAL_PPP_ORDER_STATUS_PENDING', '0',  '6', '5', 'xtc_cfg_pull_down_order_statuses(', 'xtc_get_order_status_name', now())");
    xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_PAYPAL_PPP_ORDER_STATUS_PENDING_USE', 'True',  '6', '6', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
    
    xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, use_function, date_added) values ('MODULE_PAYMENT_PAYPAL_PPP_ORDER_STATUS_COMPLETED', '0',  '6', '7', 'xtc_cfg_pull_down_order_statuses(', 'xtc_get_order_status_name', now())");
    xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_PAYPAL_PPP_ORDER_STATUS_COMPLETED_USE', 'True',  '6', '8', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
    
    xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, use_function, date_added) values ('MODULE_PAYMENT_PAYPAL_PPP_ORDER_STATUS_REFUNDET', '0',  '6', '9', 'xtc_cfg_pull_down_order_statuses(', 'xtc_get_order_status_name', now())");
    xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_PAYPAL_PPP_ORDER_STATUS_REFUNDET_USE', 'True',  '6', '10', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
    
    xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, use_function, date_added) values ('MODULE_PAYMENT_PAYPAL_PPP_ORDER_STATUS_REVERSED', '0',  '6', '11', 'xtc_cfg_pull_down_order_statuses(', 'xtc_get_order_status_name', now())");
    xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_PAYPAL_PPP_ORDER_STATUS_REVERSED_USE', 'True',  '6', '12', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
    
    xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_PAYPAL_PPP_REPLACE_CHECKOUT', 'False', '6', '13', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
    xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PAYPAL_PPP_PAYMENT_INCLUDE', 'moneyorder,invoice,billsafe_2,sofort_sofortueberweisung', '6', '14', now())");
    xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_PAYPAL_PPP_BUTTON_CART', 'True', '6', '15', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
    xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_PAYPAL_PPP_LOGIN_BUTTON_CART', 'True', '6', '16', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
    xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_PAYPAL_PPP_EXPRESS_BUTTON_CART', 'False', '6', '17', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
    
    xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_PAYPAL_PPP_TEST', 'True', '6', '19', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
    xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added, set_function) values ('MODULE_PAYMENT_PAYPAL_PPP_MODE', 'sandbox',  '6', '20', now(), 'xtc_cfg_select_option(array(\'live\', \'sandbox\'), ')");
    xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PAYPAL_PPP_APICLIENTID', '',  '6', '21', now())");
    xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PAYPAL_PPP_APICLIENTID_SANDBOX', '',  '6', '22', now())");
    xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PAYPAL_PPP_APISECRET', '',  '6', '23', now())");
    xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PAYPAL_PPP_APISECRET_SANDBOX', '',  '6', '24', now())");
    xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PAYPAL_PPP_IMAGE', '',  '6', '25', now())");
    
    xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_PAYPAL_PPP_USE_LANG_TEXT', 'True', '6', '28', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
    xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PAYPAL_PPP_INTROTITLE', 'Zahlung per Lastschrift, Kreditkarte oder PayPal-Konto', '6', '29', now())");
    xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PAYPAL_PPP_INTROTEXT', '&Uuml;bergeben Sie die Zahlung an PayPal als Zahlungsdienstleister',  '6', '30', now())");
    
    xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_PAYPAL_PPP_SUMMARZIE_CART', 'False', '6', '35', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
    xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PAYPAL_PPP_SUMMARZIE_CART_TEXT', '', '6', '36', now())");
    xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, use_function, date_added) values ('MODULE_PAYMENT_PAYPAL_PPP_ORDER_STATUS_PAYPAL_ERROR', '0',  '6', '37', 'xtc_cfg_pull_down_order_statuses(', 'xtc_get_order_status_name', now())");
    
    xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_PAYPAL_PPP_REFRESH_EXPERIENCE', 'True',  '6', '99', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
    
    /* Hidden Fields */
    xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PAYPAL_PPP_EXPERIENCE_PROFILE_ID', '',  '6', '500', now())");
    xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PAYPAL_PPP_API_ACCESS_TOKEN', '',  '6', '501', now())");
    xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PAYPAL_PPP_API_ACCESS_TOKENTIME', '0',  '6', '502', now())");
    xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PAYPAL_PPP_SB_EXPERIENCE_PROFILE_ID', '',  '6', '503', now())");
    xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PAYPAL_PPP_SB_API_ACCESS_TOKEN', '',  '6', '504', now())");
    xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PAYPAL_PPP_SB_API_ACCESS_TOKENTIME', '0', '6',  '505', now())");
    xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PAYPAL_PPP_WEBHOOK_ID', '',  '6', '506', now())");
    xtc_db_query("insert into ".TABLE_CONFIGURATION." ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PAYPAL_PPP_SB_WEBHOOK_ID', '',  '6', '507', now())");
    
    xtc_db_query("CREATE TABLE IF NOT EXISTS `paypal_ppp` (
      `id` int(11) NOT NULL AUTO_INCREMENT,
      `orders_id` int(11) NOT NULL DEFAULT '0',
      `ppp_payment_id` varchar(64) NOT NULL DEFAULT '',
      `ppp_sale_id` varchar(64) NOT NULL DEFAULT '',
      `payer_id` varchar(128) NOT NULL DEFAULT '',
      `payer_email` varchar(256) NOT NULL DEFAULT '',
      `payer_first_name` varchar(256) NOT NULL DEFAULT '',
      `payer_last_name` varchar(256) NOT NULL DEFAULT '',
      `payer_shipping_address` text NOT NULL DEFAULT '',
      `payer_status` varchar(64) NOT NULL DEFAULT '',
      `payment_total` decimal(9,2) NOT NULL DEFAULT '0.00',
      `payment_total_currency` varchar(5) NOT NULL DEFAULT '',
      `payment_fee` decimal(7,2) NOT NULL DEFAULT '0.00',
      `payment_fee_currency` varchar(5) NOT NULL DEFAULT 'EUR',
      `payment_mode` varchar(128) NOT NULL DEFAULT '',
      `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
      `mode` varchar(24) NOT NULL DEFAULT 'live',
      `payment_type` varchar(64) NOT NULL DEFAULT '',
      `payment_instruction` TEXT NOT NULL DEFAULT '',
      PRIMARY KEY (`id`),
      UNIQUE KEY `ppp_payment_id` (`ppp_payment_id`),
      UNIQUE KEY `orders_id` (`orders_id`),
      KEY `ppp_sale_id` (`ppp_sale_id`)
    ) ENGINE=MyISAM AUTO_INCREMENT=1");
    
    xtc_db_query("CREATE TABLE IF NOT EXISTS `paypal_ppp_status_history` (
      `id` int(11) NOT NULL AUTO_INCREMENT,
      `paypal_ppp_id` varchar(64) COLLATE latin1_german1_ci NOT NULL DEFAULT '',
      `orders_id` int(11) NOT NULL DEFAULT '0',
      `status` varchar(64) COLLATE latin1_german1_ci NOT NULL,
      `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
      `amount` decimal(9,2) NOT NULL DEFAULT '0.00',
      `summary` text NOT NULL DEFAULT '',
      `pending_reason` text NOT NULL DEFAULT '',
      PRIMARY KEY (`id`),
      KEY `paypal_ppp_id` (`paypal_ppp_id`),
      KEY `orders_id` (`orders_id`)
    ) ENGINE=MyISAM AUTO_INCREMENT=1");
    
    $check_query = xtc_db_query("SHOW COLUMNS FROM `".TABLE_ADMIN_ACCESS."` LIKE 'paypal_ppp'");
		if(xtc_db_num_rows($check_query) < 1)
    {
			xtc_db_query("ALTER TABLE `".TABLE_ADMIN_ACCESS."` ADD `paypal_ppp` TINYINT(1) NOT NULL DEFAULT 0");
			xtc_db_query("UPDATE `".TABLE_ADMIN_ACCESS."` SET `paypal_ppp`=1 WHERE `customers_id`=1 LIMIT 1");
      xtc_db_query("UPDATE `".TABLE_ADMIN_ACCESS."` SET `paypal_ppp`=3 WHERE `customers_id`='groups' LIMIT 1");
			if($_SESSION['customer_id']!=1)
				xtc_db_query("UPDATE `".TABLE_ADMIN_ACCESS."` SET `paypal_ppp`=1 WHERE `customers_id`=".$_SESSION['customer_id']." LIMIT 1");
    }
	}

	function remove() {
  
    // ich muss auch die Daten bei PayPal lschen!
    if (MODULE_PAYMENT_PAYPAL_PPP_APICLIENTID != '' && MODULE_PAYMENT_PAYPAL_PPP_APISECRET != '')
    {
      if (MODULE_PAYMENT_PAYPAL_PPP_EXPERIENCE_PROFILE_ID != '' || MODULE_PAYMENT_PAYPAL_PPP_WEBHOOK_ID != '')
      {
        $ppp_rest = new PAYPAL_PPP_REST('live');
        if (MODULE_PAYMENT_PAYPAL_PPP_EXPERIENCE_PROFILE_ID != '')
        {
          $ppp_rest->prepare_request('v1/payment-experience/web-profiles/'.MODULE_PAYMENT_PAYPAL_PPP_WEBHOOK_ID, 'DELETE');
          $ppp_rest->add_custom_header('Authorization: Bearer '.$ppp_rest->get_api_access_token());
        }
        if (MODULE_PAYMENT_PAYPAL_PPP_WEBHOOK_ID != '')
        {
          $ppp_rest->prepare_request('v1/payment-experience/webhooks-events/'.MODULE_PAYMENT_PAYPAL_PPP_WEBHOOK_ID, 'DELETE');
          $ppp_rest->add_custom_header('Authorization: Bearer '.$ppp_rest->get_api_access_token());
        }
      }
    }
    
    if (MODULE_PAYMENT_PAYPAL_PPP_APICLIENTID_SANDBOX != '' && MODULE_PAYMENT_PAYPAL_PPP_APISECRET_SANDBOX != '')
    {
      if (MODULE_PAYMENT_PAYPAL_PPP_SB_EXPERIENCE_PROFILE_ID != '' || MODULE_PAYMENT_PAYPAL_PPP_SB_WEBHOOK_ID != '')
      {
        $ppp_rest = new PAYPAL_PPP_REST('sandbox');
        if (MODULE_PAYMENT_PAYPAL_PPP_SB_EXPERIENCE_PROFILE_ID != '')
        {
          $ppp_rest->prepare_request('v1/payment-experience/web-profiles/'.MODULE_PAYMENT_PAYPAL_PPP_SB_EXPERIENCE_PROFILE_ID, 'DELETE');
          $ppp_rest->add_custom_header('Authorization: Bearer '.$ppp_rest->get_api_access_token());
        }
        if (MODULE_PAYMENT_PAYPAL_PPP_SB_WEBHOOK_ID != '')
        {
          $ppp_rest->prepare_request('v1/payment-experience/webhooks-events/'.MODULE_PAYMENT_PAYPAL_PPP_SB_WEBHOOK_ID, 'DELETE');
          $ppp_rest->add_custom_header('Authorization: Bearer '.$ppp_rest->get_api_access_token());
        }
      }
    }
      
		xtc_db_query("delete from ".TABLE_CONFIGURATION." where configuration_key in ('".implode("', '", $this->keys())."')");
    
    $hidden_fields = array('MODULE_PAYMENT_PAYPAL_PPP_EXPERIENCE_PROFILE_ID','MODULE_PAYMENT_PAYPAL_PPP_API_ACCESS_TOKEN','MODULE_PAYMENT_PAYPAL_PPP_API_ACCESS_TOKENTIME','MODULE_PAYMENT_PAYPAL_PPP_SB_EXPERIENCE_PROFILE_ID','MODULE_PAYMENT_PAYPAL_PPP_SB_API_ACCESS_TOKEN','MODULE_PAYMENT_PAYPAL_PPP_SB_API_ACCESS_TOKENTIME',
    'MODULE_PAYMENT_PAYPAL_PPP_WEBHOOK_ID','MODULE_PAYMENT_PAYPAL_PPP_SB_WEBHOOK_ID');
    xtc_db_query("delete from ".TABLE_CONFIGURATION." where configuration_key in ('".implode("', '", $hidden_fields)."')");
    
    $check_query = xtc_db_query("SHOW COLUMNS FROM `".TABLE_ADMIN_ACCESS."` LIKE 'paypal_ppp'");
    if(xtc_db_num_rows($check_query) == 1)
      xtc_db_query("ALTER TABLE `".TABLE_ADMIN_ACCESS."` DROP COLUMN `paypal_ppp`");
	}

	function keys() {
		return array ('MODULE_PAYMENT_PAYPAL_PPP_STATUS', 'MODULE_PAYMENT_PAYPAL_PPP_ALLOWED', 'MODULE_PAYMENT_PAYPAL_PPP_SORT_ORDER', 'MODULE_PAYMENT_PAYPAL_PPP_MODE', 'MODULE_PAYMENT_PAYPAL_PPP_TEST',
    'MODULE_PAYMENT_PAYPAL_PPP_REPLACE_CHECKOUT', 'MODULE_PAYMENT_PAYPAL_PPP_PAYMENT_INCLUDE',
    'MODULE_PAYMENT_PAYPAL_PPP_BUTTON_CART', 'MODULE_PAYMENT_PAYPAL_PPP_LOGIN_BUTTON_CART', 'MODULE_PAYMENT_PAYPAL_PPP_EXPRESS_BUTTON_CART',
    'MODULE_PAYMENT_PAYPAL_PPP_SUMMARZIE_CART', 'MODULE_PAYMENT_PAYPAL_PPP_SUMMARZIE_CART_TEXT',
    'MODULE_PAYMENT_PAYPAL_PPP_ORDER_STATUS_PENDING', 'MODULE_PAYMENT_PAYPAL_PPP_ORDER_STATUS_PENDING_USE',
    'MODULE_PAYMENT_PAYPAL_PPP_ORDER_STATUS_COMPLETED', 'MODULE_PAYMENT_PAYPAL_PPP_ORDER_STATUS_COMPLETED_USE',
    'MODULE_PAYMENT_PAYPAL_PPP_ORDER_STATUS_REFUNDET', 'MODULE_PAYMENT_PAYPAL_PPP_ORDER_STATUS_REFUNDET_USE',
    'MODULE_PAYMENT_PAYPAL_PPP_ORDER_STATUS_REVERSED', 'MODULE_PAYMENT_PAYPAL_PPP_ORDER_STATUS_REVERSED_USE',
    'MODULE_PAYMENT_PAYPAL_PPP_ORDER_STATUS_PAYPAL_ERROR',
    'MODULE_PAYMENT_PAYPAL_PPP_APICLIENTID', 'MODULE_PAYMENT_PAYPAL_PPP_APISECRET', 'MODULE_PAYMENT_PAYPAL_PPP_APICLIENTID_SANDBOX', 'MODULE_PAYMENT_PAYPAL_PPP_APISECRET_SANDBOX', 
    'MODULE_PAYMENT_PAYPAL_PPP_USE_LANG_TEXT', 'MODULE_PAYMENT_PAYPAL_PPP_INTROTITLE', 'MODULE_PAYMENT_PAYPAL_PPP_INTROTEXT', 'MODULE_PAYMENT_PAYPAL_PPP_IMAGE', 'MODULE_PAYMENT_PAYPAL_PPP_REFRESH_EXPERIENCE');
	}
}
?>
