<?php
/* includes/modules/payment/paypal_ppp/hook_admin_print_order.php
.---------------------------------------------------------------------------.
|    Software: PayPal-Plus-Module                                           |
|     Version: 0.1beta                                                      |
|        Date: 2015-10-28                                                   |
| Description: hook add changes to admin/print_order.php                    |
|     Contact: info@andreas-guder.de                                        |
| ------------------------------------------------------------------------- |
|      Author: Andreas Guder                                                |
|     Contact: info@andreas-guder.de                                        |
| Copyright (c) 2015, Andreas Guder.                                        |
| ------------------------------------------------------------------------- |
|     License:  GNU Public License V2.0                                     |
|               http://www.gnu.org/licenses/gpl-2.0.html                    |
'--------------------------------------------------------------------------'
*/
if (substr($order->info['payment_method'],0,10) == 'paypal_ppp' && defined('MODULE_PAYMENT_PAYPAL_PPP_STATUS'))
{
  if (file_exists(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/payment/paypal_ppp.php'))
  {
    include_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/payment/paypal_ppp.php');
    $q = xtc_db_query("SELECT `payment_type`, `payment_instruction` FROM `".TABLE_PAYPAL_PPP."` WHERE `orders_id`=".$order->info['order_id']);
    $payment = xtc_db_fetch_array($q);
    xtc_db_free_result($q);
    if (is_array($payment))
    {
      if ($payment['payment_type'] != '')
      {
        $srp = array('search'=>array(), 'replace'=>array());
        if ($payment['payment_type'] == 'PAY_UPON_INVOICE' && $payment['payment_instruction'] != '')
        {
          $payment_instruction = unserialize($payment['payment_instruction']);
          $search_replace = array(
            'reference'   => $payment_instruction['reference_number'],
            'bank_name'   => $payment_instruction['recipient_banking']['bank'],
            'bank_holder' => $payment_instruction['recipient_banking']['holder'],
            'bank_iban'   => $payment_instruction['recipient_banking']['iban'],
            'bank_bic'    => $payment_instruction['recipient_banking']['bic'],
            'amount'      => number_format($payment_instruction['amount']['amount'],2,',','').' '.$payment_instruction['amount']['currency'],
            'payment_date'=> date('d.m.Y',strtotime($payment_instruction['payment_due_date']))
          );
          
          foreach ($search_replace as $key => $value)
          {
            $srp['search'][] = '{$'.$key.'}';
            $srp['replace'][] = $value;
          }
        }
        
        if ($order->info['payment_method'] == 'paypal_ppp_rechnung')
        {
          if (defined('MODULE_PAYMENT_PAYPAL_PPP_RECHNUNG_TEXT_TITLE'))
            $smarty->assign('PAYMENT_METHOD',MODULE_PAYMENT_PAYPAL_PPP_RECHNUNG_TEXT_TITLE);
          if (defined('MODULE_PAYMENT_PAYPAL_PPP_RECHNUNG_TEXT_INSTRUCTION'))
          {
            $instruct = MODULE_PAYMENT_PAYPAL_PPP_RECHNUNG_TEXT_INSTRUCTION;
            if (!empty($srp['search']))
              $instruct = str_replace($srp['search'], $srp['replace'], $instruct);
            $smarty->assign('PPP_PAYMENT_INSTRUCTION',$instruct);
          }
        }
        else
        {
          if (defined('MODULE_PAYMENT_PAYPAL_PPP_TEXT_TITLE_PAYMENTTYPE_'.strtoupper($payment['payment_type'])))
          {
            $payment_method = constant('MODULE_PAYMENT_PAYPAL_PPP_TEXT_TITLE_PAYMENTTYPE_'.strtoupper($payment['payment_type']));
            $smarty->assign('PAYMENT_METHOD',$payment_method);
          }
          if (defined('MODULE_PAYMENT_PAYPAL_PPP_TEXT_INSTRUCT_PAYMENTTYPE_'.strtoupper($payment['payment_type'])))
          {
            $instruct = constant('MODULE_PAYMENT_PAYPAL_PPP_TEXT_INSTRUCT_PAYMENTTYPE_'.strtoupper($payment['payment_type']));
            if (!empty($srp['search']))
              $instruct = str_replace($srp['search'], $srp['replace'], $instruct);
            $smarty->assign('PPP_PAYMENT_INSTRUCTION',$instruct);
          }
        }
      }
    }
  }
}
?>