<?php
/**
 *
 *
 * @version Sofort�berweisung 1.9  05.06.2007
 * @author Henri Schmidhuber  info@in-solution.de
 * @copyright 2006 - 2007 Henri Schmidhuber
 * @link http://www.in-solution.de
 * @link http://www.xt-commerce.com
 * @link http://www.sofort-ueberweisung.de
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 ***********************************************************************************
 * this file contains code based on:
 * (c) 2000 - 2001 The Exchange Project
 * (c) 2001 - 2003 osCommerce, Open Source E-Commerce Solutions
 * (c) 2003	 nextcommerce (account_history_info.php,v 1.17 2003/08/17); www.nextcommerce.org
 * (c) 2003 - 2006 XT-Commerce
 * Released under the GNU General Public License
 ***********************************************************************************
 *
 */

  class sofortueberweisungvorkasse {
    var $code, $title, $description, $enabled;

// class constructor
    function __construct() {
      global $order;

      $this->code = 'sofortueberweisungvorkasse';
      $this->title = MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_TEXT_TITLE;
      $this->description = MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_TEXT_DESCRIPTION;
      $this->sort_order = (defined('MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_SORT_ORDER')) ? MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_SORT_ORDER : 0;
      $this->enabled = (defined('MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_STATUS') and MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_STATUS == 'True') ? true : false;
      if($this->enabled === true){
          $this->redirect = false;
          $this->email_footer = MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_TEXT_EMAIL_FOOTER;
      }
      if (is_object($order)) $this->update_status();

    }

// class methods
    function update_status() {
        global $order;

        if ( ($this->enabled == true) && ((int)MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_ZONE > 0) ) {
            $check_flag = \YES4Trade\Model\zones_to_geo_zones::is_module_payment_zone_valid(
                intval(MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_ZONE),
                intval($order->billing['country']['id']),
                intval($order->billing['zone_id'])
            );
            if ($check_flag == false) {
              $this->enabled = false;
            }
        }
    }

    function javascript_validation() {
      return false;
    }

    function selection() {
      return array('id' => $this->code,
                   'module' => $this->title,
                   'fields' => array(array('title' => MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_TEXT_DESCRIPTION_CHECKOUT_PAYMENT)));
    }

    function pre_confirmation_check() {
      return false;
    }

    function confirmation() {
      return array('title' => MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_TEXT_DESCRIPTION_CHECKOUT_CONFIRMATION);
    }

    function process_button() {
      global $order, $xtPrice;
  		if ($_SESSION['customers_status']['customers_status_show_price_tax'] == 0 && $_SESSION['customers_status']['customers_status_add_tax_ot'] == 1) {
	  		$total = $order->info['total'] + $order->info['tax'];
		  } else {
			  $total = $order->info['total'];
		  }

      // Fix for XTC Bug
      // $order->info['total'] is in 'after_process' String with currency -> 1.02 EUR
      // so it has to be set here
      $_SESSION['sofortueberweisung_total'] = round($xtPrice->xtcCalculateCurrEx($total, 'EUR'), $xtPrice->get_decimal_places('EUR'));
      return false;
    }

    function before_process() {

      return false;
    }

    function after_process() {
      global $order, $xtPrice, $mail_error, $order_total_modules;
      $_SESSION['cart']->reset(true);
      // unregister session variables used during checkout
      unset($_SESSION['sendto']);
      unset($_SESSION['billto']);
      unset($_SESSION['shipping']);
      unset($_SESSION['payment']);
      unset($_SESSION['comments']);
      unset($_SESSION['last_order']);
      //GV Code Start
      if(isset($_SESSION['credit_covers'])) unset($_SESSION['credit_covers']);
      $order_total_modules->clear_posts();//ICW ADDED FOR CREDIT CLASS SYSTEM
      // GV Code End

      if (!isset($mail_error)) {
        xtc_redirect(xtc_href_link('sofortueberweisung_checkout_success.php', 'sofortueberweisung_payment=' . $this->code, 'SSL'));
      }
      else {
        echo $mail_error;
      }
      exit();
      return false;
    }

    function checkout_success($insert_id) {
      $customer_id = $_SESSION['customer_id'];
      require_once (DIR_WS_CLASSES.'order.php');
      $xt = yes_query(
      	"SELECT customers_status, currency FROM %s WHERE orders_id=:orders_id",
      	['orders_id'=>$insert_id],
        true
      );
      if(empty($xt['currency'])){
	      $xt['currency'] = DEFAULT_CURRENCY;
      }
      $xtPrice = new xtcPrice($xt['currency'],$xt['customers_status']);
      $order =  new order((int)$insert_id,$xtPrice);
      $parameter= array();
      $return = '';
		  $parameter['kdnr']	= MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_KDNR;  // Repr�sentiert Ihre Kundennummer bei der Sofort�berweisung
		  $parameter['projekt'] = MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_PROJEKT;  // Die verantwortliche Projektnummer bei der Sofort�berweisung, zu der die Zahlung geh�rt
      $parameter['betrag'] = $_SESSION['sofortueberweisung_total'];
      // number_format($order->info['total'] *  $currencies->get_value('EUR'), 2, '.','');   // Beziffert den Zahlungsbetrag, der an Sie �bermittelt werden soll
      $vzweck1 = str_replace('{{orderid}}', $insert_id, MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_TEXT_V_ZWECK_1);
      $vzweck2 = str_replace('{{orderid}}', $insert_id, MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_TEXT_V_ZWECK_2);

      $vzweck1 = str_replace('{{order_date}}', yes_strftime(DATE_FORMAT_SHORT), $vzweck1);
      $vzweck2 = str_replace('{{order_date}}', yes_strftime(DATE_FORMAT_SHORT), $vzweck2);

      $vzweck1 = str_replace('{{customer_id}}', $customer_id, $vzweck1);
      $vzweck2 = str_replace('{{customer_id}}', $customer_id, $vzweck2);

      $vzweck1 = str_replace('{{customer_cid}}', $order->customer['csID'], $vzweck1);
      $vzweck2 = str_replace('{{customer_cid}}', $order->customer['csID'], $vzweck2);

      $vzweck1 = str_replace('{{customer_name}}', $order->customer['name'], $vzweck1);
      $vzweck2 = str_replace('{{customer_name}}', $order->customer['name'], $vzweck2);

      $vzweck1 = str_replace('{{customer_company}}', $order->customer['company'], $vzweck1);
      $vzweck2 = str_replace('{{customer_company}}', $order->customer['company'], $vzweck2);

      $vzweck1 = str_replace('{{customer_email}}', $order->customer['email_address'], $vzweck1);
      $vzweck2 = str_replace('{{customer_email}}', $order->customer['email_address'], $vzweck2);

      // K�rzen auf 27 Zeichen
      $vzweck1 = substr($vzweck1, 0, 27);
      $vzweck2 = substr($vzweck2, 0, 27);

      $parameter['v_zweck_1'] = xtc_parse_input_field_data($vzweck1, array('"' => '&quot;'));  // Definieren Sie hier Ihre Verwendungszwecke
      $parameter['v_zweck_2'] = xtc_parse_input_field_data($vzweck2, array('"' => '&quot;'));  // Definieren Sie hier Ihre Verwendungszwecke

		  $parameter['kunden_var_0'] = xtc_parse_input_field_data($insert_id, array('"' => '&quot;'));;  // Eindeutige Identifikation der Zahlung, z.B. Session ID oder Auftragsnummer.
		  $parameter['kunden_var_1'] = xtc_parse_input_field_data($customer_id, array('"' => '&quot;'));;  // Eindeutige Identifikation der Zahlung, z.B. Session ID oder Auftragsnummer.
		  $parameter['kunden_var_2'] = xtc_parse_input_field_data(xtc_session_id(), array('"' => '&quot;'));;
		  $parameter['kunden_var_3'] = xtc_parse_input_field_data($cart->cartID, array('"' => '&quot;'));;
		  $parameter['kunden_var_4'] = '';
		  $parameter['kunden_var_5'] = '';


		  if (strlen(MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_INPUT_PASSWORT) > 0) {
        $tmparray = array(
          $parameter['betrag'],
          $parameter['v_zweck_1'],
          $parameter['v_zweck_2'],
          '', // von_konto_inhaber
          '', // von_konto_nr
          '', // von_konto_blz
          $parameter['kunden_var_0'],
          $parameter['kunden_var_1'],
          $parameter['kunden_var_2'],
          $parameter['kunden_var_3'],
          $parameter['kunden_var_4'],
          $parameter['kunden_var_5'],
          MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_INPUT_PASSWORT);
		   $parameter['key'] = md5(implode("|", $tmparray));
		  }

      foreach ($parameter as $key => $value) {
        $return .= xtc_draw_hidden_field($key, $value). "\n";
      }
		  return $return;
    }
    function get_error() {
      return false;
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
      // Update Configuration Key Length 64 is often too short
      xtc_db_query('ALTER TABLE ' . TABLE_CONFIGURATION . ' CHANGE configuration_key configuration_key VARCHAR( 255 ) NOT NULL');
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ( 'MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_STATUS', 'True', '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now());");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_ALLOWED', '', '6', '0', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_KDNR', '10000', '6', '1', now());");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_PROJEKT', '500000', '6', '1', now());");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_INPUT_PASSWORT', 'abcdef', '6', '1', now());");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_BNA_PASSWORT', '123456', '6', '1', now());");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_SORT_ORDER', '0', '6', '0', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, use_function, set_function, date_added) values ('MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_ZONE', '0', '6', '2', 'xtc_get_zone_class_title', 'xtc_cfg_pull_down_zone_classes(', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, use_function, date_added) values ('MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_ORDER_STATUS_ID', '0', '6', '0', 'xtc_cfg_pull_down_order_statuses(', 'xtc_get_order_status_name', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_STORE_TR_DETAILS', 'False', '6', '6', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now());");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_IS_SHIPPING_BEFORE_PAYMENT', 'True', '6', '4', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now());");
    }

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_STATUS', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_ALLOWED', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_ZONE', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_ORDER_STATUS_ID', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_SORT_ORDER', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_KDNR', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_PROJEKT', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_INPUT_PASSWORT', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_BNA_PASSWORT', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_STORE_TR_DETAILS','MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_IS_SHIPPING_BEFORE_PAYMENT');
    }
  }
