<?php
/* -----------------------------------------------------------------------------------------
   $Id: product_listing.php,v 1.77 2020/04/03 10:37:38 ssh-511548-cvs Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(product_listing.php,v 1.42 2003/05/27); www.oscommerce.com 
   (c) 2003	 nextcommerce (product_listing.php,v 1.19 2003/08/1); www.nextcommerce.org

   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/
$module_smarty= new yesSmarty;
$module_smarty->assign('tpl_path','templates/'.CURRENT_TEMPLATE.'/');
if(strstr($_SERVER['SCRIPT_NAME'],'advanced_search_result')){
	$url = xtc_href_link('advanced_search_result.php',xtc_get_all_get_params(array('ajaxscrolldown','page','set','noset')).'ajaxscrolldown=1');
	if(isset($_REQUEST['set']) and is_array($_REQUEST['set'])){
		foreach($_REQUEST['set'] as $k=>$v){
			$url .= '&set[]='.xtc_db_input($v);
		}
	}
	if(isset($_REQUEST['noset']) and is_array($_REQUEST['noset'])){
		foreach($_REQUEST['noset'] as $k=>$v){
			$url .= '&noset[]='.xtc_db_input($v);
		}
	}
	$module_smarty->assign('AJAX_SCROLLDOWN_URL',$url);
}else if(strstr($_SERVER['SCRIPT_NAME'],'index')){
	$usersort = '';
	if(isset($_REQUEST['usersort'])){
		$usersort = '&usersort='.xtc_db_input($_REQUEST['usersort']);
	}
	$url = xtc_href_link('index.php',xtc_get_all_get_params(array('ajaxscrolldown','page','set','noset')).'ajaxscrolldown=1');
	$module_smarty->assign('AJAX_SCROLLDOWN_URL',$url);
}

function _getcatname($id){
    global $InstanceCache;
    $language_id = intval($_SESSION['languages_id']??2);
    $cache_key = 'shop.categories.description-'.intval($id).'-'.$language_id;
    $cache_group = 'categories';
    $key = \yescache_helper::cache_key($InstanceCache, $cache_group, $cache_key);

    $CachedString = $InstanceCache->getItem($key); // cache group
    if (!$CachedString->isHit()) {
        $catd = \YES4Trade\Model\categories_description::get_by_categories_id_and_language_id(
                intval($id), $language_id,[
            'categories_name'
        ]);
        $categories_name = $catd->categories_name??'';
        $CachedString->set($categories_name)->expiresAfter(YES_CACHE_LIFETIME_LONG);//cat
        $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
    }else{
        $categories_name = $CachedString->get();
    }
    return $categories_name;
}
		
$result=true;
// include needed functions
require_once(DIR_WS_CLASSES . 'product.php');
require_once(DIR_FS_INC . 'xtc_get_all_get_params.inc.php');
require_once(DIR_FS_INC . 'xtc_image_button.inc.php');
require_once(DIR_FS_INC . 'xtc_get_shipping_status_name.inc.php');
require_once(DIR_FS_INC . 'xtc_collis.inc.php');
require_once(DIR_FS_INC . 'yes_get_ext_traffic.inc.php');
require_once(DIR_FS_INC . 'xtc_get_vpe_name.inc.php');
require_once('admin/includes/classes/class.storagequantity.php');

$dropdown = xtc_draw_pull_down_menu('customer_sort', array(
    array('id'=>'price_asc','text'=>'Preis aufsteigend'),
    array('id'=>'price_desc','text'=>'Preis absteigend'),
    array('id'=>'date_asc','text'=>'Datum aufsteigend'),
    array('id'=>'date_desc','text'=>'Datum absteigend')
));
//echo $dropdown;
$page = max(0,yes_getIntFromRequest('page'));
$element_counter = 1;
if(isset($_REQUEST['ajaxscrolldown'])){
    $module_smarty->assign('ajaxscrolldown','1');
    $element_counter = $page+1;
    $page_nr = ($page / MAX_DISPLAY_SEARCH_RESULTS)+1;
    $_GET['page'] = intval($page_nr);
    $page = max(0,yes_getIntFromRequest('page'));
}
/**
 * BOF - KATEGORIE MATCHES 
 * ERMITTELT AUS ALLEN GEFUNDEN ARTIKELN, IN WELCHEN KATEGORIEN DIESE
 * ZU FINDEN SIND
 */
$parts = explode(' from ',$listing_sql);
$cat_matches_sql = '';
foreach($parts as $k=>$v){
    if($k == 0){
        continue;
    }
    $cat_matches_sql .= ' FROM '.$v;
}
if(isset($_REQUEST['uop']) and $_REQUEST['uop'] == 1){
    foreach($parameters as $k=>$v){
        if(strpos($k,'set_id_')>-1){
            $parameters[$k] = null;
            unset($parameters[$k]);
        }
    }
}
$cache_key = 'shop.categories.allocation-'.md5(serialize($parameters));
$cache_group = 'categories';
$key = \yescache_helper::cache_key($InstanceCache, $cache_group, $cache_key);

$CachedString = $InstanceCache->getItem($key); // cache group
if (!$CachedString->isHit()) {
    try{
        $cat_matches_query = yes_query(sprintf(
            "SELECT p2c.categories_id %s",$cat_matches_sql
        ), $parameters);
    } catch (PDOException $e) {
        // Nur SQLSTATE[HY000] und Fehlercode 1267 (Collation-Konflikt)
        $sqlState = $e->getCode();
        $errorCode = $e->errorInfo[1] ?? null;

        if ($sqlState === 'HY000' && $errorCode === 1267) {
            // Leise behandeln → keine Treffer
            $cat_matches_query = false;
        } else {
            // Alle anderen Fehler normal weiterwerfen
            throw $e;
        }
    }
    // WENN MAN bool WERTE IM CACHE SPEICHERT, FUEHRT DAS ZU FEHLERN
    if($cat_matches_query !== false){
        $CachedString->set($cat_matches_query)->expiresAfter(YES_CACHE_LIFETIME_LONG);//cat
        $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
    }else{
        $cat_matches_query = [];
    }
}else{
    $cat_matches_query = $CachedString->get();
}
$cat_matches = array();
if(sizeOf($cat_matches_query)>0){
    foreach($cat_matches_query as $cat_matches_res){
        if(!isset($cat_matches[ $cat_matches_res['categories_id'] ])){
            $cat_matches[ $cat_matches_res['categories_id'] ] = 0;
        }
        $cat_matches[ $cat_matches_res['categories_id'] ]++;
    }
}

// BOF - KATEGORIE MATCHES 
$cache_key = 'product_listing.categories.split-page_'.$page.'-'.md5(serialize($parameters).$listing_sql);
$cache_group = 'categories';
$key = \yescache_helper::cache_key($InstanceCache, $cache_group, $cache_key);
$CachedString = $InstanceCache->getItem($key); // cache group

if (!$CachedString->isHit()) {
    $m_limit = (defined('MAX_DISPLAY_SEARCH_RESULTS')) ? constant('MAX_DISPLAY_SEARCH_RESULTS') : 20;
    $listing_split = new splitPageResults($listing_sql, $page, 
        $m_limit,'p.products_id',true, $parameters);
    $CachedString->set($listing_split)->expiresAfter(YES_CACHE_LIFETIME_LONG);//cat
    $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
}else{
    $listing_split = $CachedString->get();
}
$cache_key = 'product_listing.categories.results-page_'.$page.'-'.md5(serialize($parameters).$listing_sql);
$cache_group = 'categories';
$key = \yescache_helper::cache_key($InstanceCache, $cache_group, $cache_key);

$CachedString = $InstanceCache->getItem($key); // cache group
if (!$CachedString->isHit()) {
    try{
        $listing_query = yes_query($listing_split->sql_query,$parameters);
    } catch (PDOException $e) {
        // Nur SQLSTATE[HY000] und Fehlercode 1267 (Collation-Konflikt)
        $sqlState = $e->getCode();
        $errorCode = $e->errorInfo[1] ?? null;

        if ($sqlState === 'HY000' && $errorCode === 1267) {
            // Leise behandeln → keine Treffer
            $listing_query = false;
        } else {
            // Alle anderen Fehler normal weiterwerfen
            throw $e;
        }
    }
    if($listing_query !== null and $listing_query !== false){
        $CachedString->set($listing_query)->expiresAfter(YES_CACHE_LIFETIME_LONG);//cat
        $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
    }
}else{
    $listing_query = $CachedString->get();
}
$module_smarty->assign('LISTING_NUM_ROWS',$listing_split->number_of_rows);
$module_content=array();
// DOPPELTE pIDs FILTERN
$main = new main;
$double_pid_array = array();
$double_manufacturer_array = array();
if ($listing_split->number_of_rows > 0) {
	$rows = 0;
	if($listing_query !== false and yes_db_num_rows($listing_query)){
		foreach($listing_query as $product_listing){
			$fsk18='';
			if ($product_listing['products_fsk18']=='1') {
				$fsk18='true';
			}
			if(!in_array($product_listing['products_id'],$double_pid_array)){
				$rows++;
				$slaves = false;
				if((int)$product_listing['products_master_status'] == 1){
                    // OPTIMIERTER Query chatgpt INNER JOIN
                    $master_sql_raw = sprintf(
                        "select p.*,pd.products_name,pd.slave_title from %s p INNER JOIN %s pd ON p.products_id=pd.products_id where p.products_master=:master_id and pd.language_id=:language_id",
                        TABLE_PRODUCTS,TABLE_PRODUCTS_DESCRIPTION
                    );
                    // ALTER QUERY
                    // $master_sql_raw = "select p.*,pd.products_name,pd.slave_title from " . TABLE_PRODUCTS . " p, products_description pd where products_master=:master_id and pd.products_id=p.products_id and pd.language_id=:language_id";

                    $master_parameters = [
                        'language_id'=>(int)$_SESSION['languages_id'],
                        'master_id'=>(int)$product_listing['products_id']
                    ];
                    // ergibt $slaves - verwendet cache
                    require(DIR_WS_MODULES.'master_listing.php');
				}

				$SQ = new products_quantity((int)$product_listing['products_id']);
				$qty_total = $SQ->get_products_total_qty();
				$ampel = $SQ->get_ampel();
				$product = new product((int)$product_listing['products_id']);
				$product_info = $product->data;
                                
				$info_array = $product->buildDataArray($product_info);
                $manufacturer_info = array();
                
                if($info_array['MANUFACTURERS_ID'] > 0){
                    if(!isset($double_manufacturer_array[$info_array['MANUFACTURERS_ID']])){
                        $double_manufacturer_array[ $info_array['MANUFACTURERS_ID'] ] = $product->getManufacturersData();
                    }
                    $manufacturer_info = $double_manufacturer_array[ $info_array['MANUFACTURERS_ID'] ];
                }
				$PRODUCTS_VPE = '';
				if ( $info_array['PRODUCTS_VPE_STATUS'] == 1 && $info_array['PRODUCTS_VPE_VALUE'] != 0.0){
					$PRODUCTS_VPE = $xtPrice->xtcFormat( ((float)str_replace(',','.',$info_array['PRODUCTS_PRICE_CLEAN'])) * (1 / $info_array['PRODUCTS_VPE_VALUE']), true).TXT_PER.xtc_get_vpe_name($info_array['PRODUCTS_VPE']);
				}
				$module_content[] = array(
					'INFO'=>$info_array,
					'PRODUCTS_NAME'=>$product_listing['products_name'],
					'SLAVES'=>$slaves,
					'AMPEL'=>$ampel,
					'PRODUCTS_MODEL'=>$product_listing['products_model'],
					'PRODUCTS_EAN'=>$product_listing['products_ean'],
					'PRODUCTS_SHORT_DESCRIPTION'=>$product_listing['products_short_description'],
					'PRODUCTS_EXTRA_TEXT'=>$product_listing['products_extra_text'],
					'PRODUCTS_IMAGE'=>$info_array['PRODUCTS_IMAGE'],
					'EXT_AMPEL'=>yes_get_ext_traffic( $qty_total,$product_listing['products_date_available'] ),
					'VERFUEGBARER_BESTAND1'=>$SQ->get_available1_qty(),
					'PHYSICAL_QTY'=>$SQ->get_products_total_qty(),
					'PRODUCTS_DATE_AVAILABLE'=>$product_listing['products_date_available'],
					'PRODUCTS_IMAGE_INFO'=>$info_array['PRODUCTS_IMAGE_INFO'],
					'PRODUCTS_PRICE_CLEAN'=>$info_array['PRODUCTS_PRICE_CLEAN'],
					'PRODUCTS_PRICE'=>$info_array['PRODUCTS_PRICE'],
					'PRODUCTS_LINK' =>$info_array['PRODUCTS_LINK'],
					'BUTTON_BUY_NOW'=>$info_array['BUTTON_BUY_NOW'],
					'PRODUCTS_FSK18' => $fsk18,
					'PRODUCTS_TAX_VALUE' => $info_array['PRODUCTS_TAX_VALUE'],
					'PRODUCTS_TAX_INFO' => $info_array['PRODUCTS_TAX_INFO'],
					'SHIPPING_NAME'=>$info_array['PRODUCTS_SHIPPING_NAME'],
					'SHIPPING_IMAGE'=>$info_array['PRODUCTS_SHIPPING_IMAGE'],
					'PRODUCTS_SHIPPING_LINK'=>$info_array['PRODUCTS_SHIPPING_LINK'],
					'PRODUCTS_ID'=>$product_listing['products_id'],
					'PRODUCTS_VPE'=>$PRODUCTS_VPE,
					'element_counter'=>$element_counter,
                    'MANUFACTURER_INFO'=>$manufacturer_info
				);
				$element_counter++;
				$double_pid_array[] = $product_listing['products_id'];
			}
		}// end foreach
	}
}
if(isset($_GET['autocomplete']) and $_GET['autocomplete'] == 1){
    $json_data = array();
    $double_json = array();
    foreach($module_content as $p){
        if(empty($p['PRODUCTS_NAME'])){
            continue;
        }
        if(in_array($p['PRODUCTS_NAME'],$double_json)){
            continue;
        }
        $double_json[] = $p['PRODUCTS_NAME'];
        $url_pre = (main::isDev(true))?HTTP_SERVER:HTTPS_SERVER;
        $img = (!strpos($p['INFO']['PRODUCTS_IMAGE'],'noimage.gif')) ? $url_pre.$p['INFO']['PRODUCTS_IMAGE'] : '';
        $json_data[] = array(
            'value'=>$p['PRODUCTS_ID'],
            'label'=>mb_substr($p['PRODUCTS_NAME'],0,38),
            'img'=>$img,
            'price'=>$p['PRODUCTS_PRICE']
        );
    }
    die(json_encode($json_data));
}

if  ($listing_split->number_of_rows > 0) {
	$get_param_set = '';
	if(isset($_REQUEST['set']) and is_array($_REQUEST['set'])){
		foreach($_REQUEST['set'] as $key_set=>$set_value){
			if(xtc_not_null($set_value)){
				$get_param_set .= '&set['.$key_set.']='.xtc_db_input($set_value);
			}
		}
	}
	$usersort = (isset($_REQUEST['usersort'])) ? '&usersort='.xtc_db_input($_REQUEST['usersort']) : '';
	$navigation='
		<table border="0" width="100%" cellspacing="0" cellpadding="2">
		<tr>
				<td class="smallText">'.$listing_split->display_count(TEXT_DISPLAY_NUMBER_OF_PRODUCTS).'</td>
				<td class="smallText" align="right">'.TEXT_RESULT_PAGE . ' ' . $listing_split->display_links(MAX_DISPLAY_PAGE_LINKS, xtc_get_all_get_params(array('page', 'info', 'x', 'y','set','usersort')).$get_param_set.$usersort).'</td>
		</tr>
		</table>';

		// BEI SUCHERGEBNISSEN AUSBLENDEN
	if($current_category_id){
		if (GROUP_CHECK=='true') {
			$group_check="and c.group_ids LIKE '%c_".$_SESSION['customers_status']['customers_status_id']."_group%'";
		}
		$category = yes_query("select
            cd.categories_description,
            cd.categories_name,
            cd.categories_heading_title,
            c.listing_template,
            c.categories_image from " .
            TABLE_CATEGORIES . " c INNER JOIN " .
            TABLE_CATEGORIES_DESCRIPTION . " cd ON c.categories_id=cd.categories_id 
            where c.categories_id =:cat_id
            ".$group_check."
            and cd.language_id =:language_id",[
                'cat_id'=> intval($current_category_id),
                'language_id'=>intval($_SESSION['languages_id'])
            ],true
        );
		$image='';
		if ($category['categories_image']!=''){
			$image=DIR_WS_IMAGES.'categories/'.$category['categories_image'];
        }
		$module_smarty->assign('CATEGORIES_NAME',$category['categories_name']);
		$module_smarty->assign('CATEGORIES_ID',$current_category_id);
		$module_smarty->assign('CATEGORIES_IMAGE',$image);
		$module_smarty->assign('CATEGORIES_HEADING_TITLE',$category['categories_heading_title']);
		$module_smarty->assign('CATEGORIES_DESCRIPTION',$category['categories_description']);
	}
} else {
    // no product found
    $result=false;
}
// get default template
if (!isset($category) or !isset($category['listing_template']) or empty($category['listing_template'])) {
    $category['listing_template'] = \YES4Trade\Model\category::get_template_file();
}else{
    $category['listing_template'] = \YES4Trade\Model\category::get_template_file($category['listing_template']);
}
if ($result!==false) {
	if(isset($manufacturer_dropdown)){
	    $module_smarty->assign('MANUFACTURER_DROPDOWN',$manufacturer_dropdown);
    }
    require_once(DIR_FS_INC.'xtc_get_category_path.inc.php');
    arsort($cat_matches);
    $category_matches = array();
    $cached_catnames = array();
    foreach($cat_matches as $categories_id=>$count){
        $path = array();
        $path_array = explode('_',xtc_get_category_path($categories_id));
        foreach($path_array as $catId){
            if(!isset($cached_catnames[$catId])){
                $cached_catnames[ $catId ] = _getcatname($catId);
            }
            $path[] = $cached_catnames[$catId];
        }
        
        
        $category_matches[] = array(
            'NUM_MATCHED_PRODUCTS'=>$count,
            'CATEGORY_ID'=>$categories_id,
            'CATEGORY_NAME'=> $path[ sizeOf($path)-1 ],
            'CATEGORY_PATH_ARRAY'=> $path,
            'CATEGORY_PATH'=>implode(' &gt; ',$path),
            'CATEGORY_SEARCH_LINK'=>xtc_href_link('advanced_search_result.php',
                xtc_get_all_get_params(array(
                    'categories_id'
                )).'categories_id='.$categories_id
            ),
        );
    }
	$module_smarty->assign(array(
        'language'=>$_SESSION['language'],
        'category_matches'=>$category_matches,
        'module_content'=>$module_content,
        'NAVIGATION'=>$navigation
    ));
	if(stristr($_SERVER['SCRIPT_NAME'],'advanced_search_result')){
		$target_file = 'advanced_search_result.php';
	}else{
		$target_file = 'index.php';
	}
	if (isset($_REQUEST['manufacturers_id']) and $_REQUEST['manufacturers_id'] > 0) {
            $man_info = \YES4Trade\Model\manufacturers_info::get_by_manufacturers_id_and_language_id(
                (int)$_REQUEST['manufacturers_id'],
                (int)$_SESSION['languages_id']
            );
            $cache_key = 'manufacturer.product_listing-mid'.intval($_REQUEST['manufacturers_id']??0);
            $CachedString = $InstanceCache->getItem($cache_key);
            if (!$CachedString->isHit()) {
                $man = \YES4Trade\Model\manufacturer::get_by_manufacturers_id((int)$_REQUEST['manufacturers_id']);
                $man_data = $man->toArray();
                $CachedString->set($man_data)->expiresAfter(YES_CACHE_LIFETIME_LONG);//manufacturer.product_listing-mid*
                $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
            }else{
                $man_data = $CachedString->get();
            }
            $module_smarty->assign(array(
                'MANUFACTURERS_NAME'=>$man_data['manufacturers_name'],
                'MANUFACTURERS_IMAGE'=>$man_data['manufacturers_image']??'',
                'MANUFACTURERS_META_TITLE'=>$man_info->manufacturers_meta_title,
                'MANUFACTURERS_META_DESCRIPTION'=>$man_info->manufacturers_meta_description,
                'MANUFACTURERS_META_KEYWORDS'=>$man_info->manufacturers_meta_keywords,
                'MANUFACTURERS_URL'=>$man_info->manufacturers_url
            ));
	}
	$module_smarty->assign('FILTER_FORM',xtc_draw_form('filter',$target_file.'?'.xtc_get_all_get_params(array('usersort'))));
	$filter = (isset($_REQUEST['usersort'])) ? xtc_db_input($_REQUEST['usersort']) : '';
	$userfilter_array = array(
		array('id'=>'','text'=>TEXT_USERFILTER_NONE),
		array('id'=>'products_date_added ASC','text'=>TEXT_USERFILTER_DATE.' '.TEXT_USERFILTER_ASC),
		array('id'=>'products_date_added DESC','text'=>TEXT_USERFILTER_DATE.' '.TEXT_USERFILTER_DESC),
		array('id'=>'bestseller ASC','text'=>TEXT_USERFILTER_BESTSELLER.' '.TEXT_USERFILTER_ASC),
		array('id'=>'bestseller DESC','text'=>TEXT_USERFILTER_BESTSELLER.' '.TEXT_USERFILTER_DESC),
		array('id'=>'price ASC','text'=>TEXT_USERFILTER_PRICE.' '.TEXT_USERFILTER_ASC),
		array('id'=>'price DESC','text'=>TEXT_USERFILTER_PRICE.' '.TEXT_USERFILTER_DESC),
		array('id'=>'pd.products_name ASC','text'=>TEXT_USERFILTER_NAME.' '.TEXT_USERFILTER_ASC),
		array('id'=>'pd.products_name DESC','text'=>TEXT_USERFILTER_NAME.' '.TEXT_USERFILTER_DESC),
	);
	$module_smarty->assign('FILTER_DROPDOWN',xtc_draw_pull_down_menu('usersort',$userfilter_array,$filter,'class="usersort_dropdown" onchange="this.form.submit();"'));
	$module_smarty->assign('FORM_END','</form>');
	// set cache ID
	if (USE_CACHE=='false') {
		$module_smarty->caching = 0;
		$module= $module_smarty->fetch(CURRENT_TEMPLATE.'/module/product_listing/'.$category['listing_template']);
	} else {
		$module_smarty->caching = 1;
		$module_smarty->cache_lifetime=CACHE_LIFETIME;
//		$module_smarty->cache_modified_check=CACHE_CHECK;
		
		$cache_id =   xtc_db_input($_GET['cPath']??'').'_'.
            $_SESSION['language'].'_'.
            $_SESSION['customers_status']['customers_status_name'].'_'.
            $_SESSION['currency'].'_'.
            xtc_db_input($_GET['manufacturers_id']??0).'_'.
            xtc_db_input($_GET['filter_id']??0).'_'.
            xtc_db_input($_GET['page']??0).'_'.
            xtc_db_input($_GET['keywords']??'').'_'.
            xtc_db_input($_GET['categories_id']??0).'_'.
            xtc_db_input($_GET['pfrom']??'').'_'.
            xtc_db_input($_GET['pto']??'').'_'.
            xtc_db_input($_REQUEST['usersort']??''.'_'.
            ((isset($_GET['set']) and is_countable($_GET['set']))?implode('--',$_GET['set']):'')
        );
        $cache_id = md5(serialize($cache_id));
		$module= $module_smarty->fetch(CURRENT_TEMPLATE.'/module/product_listing/'.$category['listing_template'],$cache_id);
	}
	$smarty->assign('main_content',$module);
	if(isset($_REQUEST['ajaxscrolldown'])){
		if( ($element_counter-1) > $listing_split->number_of_rows){
		}else{
			header('Content-Type: text/html; charset='.CHARSET);
			echo $module;
		}
	}
} else {
	$error=TEXT_PRODUCT_NOT_FOUND;
	include(DIR_WS_MODULES . FILENAME_ERROR_HANDLER);
}
