<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                              Author M. ASPELEITER <dazze@gmx.de
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/
// Needed: lang/{$lang}/modules/shipping/yes.php
// also defined in popup_shippingcosts.php  
class yes extends shipping_default_class{
    var $code, $title, $description, $icon, $enabled, $num_dp, $sort_order,
            $tax_class, $quotes;
    var $GROUP_ID_OTHER = 999999;
    var $shippingcosts_multiplikator;
    var $shippingcosts_products_multiplikator;
    var $shippingcosts_only_max;
    var $not_ship;
    var $weight_calc;
    var $show_weight = 0;
    var $weight = 0;


    function __construct() {
      global $order;
      $this->code = 'yes';
      $this->title = MODULE_SHIPPING_YES_TEXT_TITLE;
      $this->description = MODULE_SHIPPING_YES_TEXT_DESCRIPTION;
      $this->sort_order = MODULE_SHIPPING_YES_SORT_ORDER;
      $this->icon = DIR_WS_ICONS . 'shipping_yes.gif';
      $this->tax_class = MODULE_SHIPPING_YES_TAX_CLASS;
      $this->enabled = ((MODULE_SHIPPING_YES_STATUS == 'True') ? true : false);

    }

/**
 * class methods
 */
    function quote($method = '') {
      // $order_workaround brauchen wir in der Kaufabwicklung
      global $order, $shipping_weight, $shipping_num_boxes;
      $dest_country = $order->delivery['country']['iso_code_2'];
      $country_id = $order->delivery['country']['id'];
      $tax_zone_id = (isset($order->delivery['zone_id'])) ? $order->delivery['zone_id'] : 0;
      
      if(basename($_SERVER['SCRIPT_NAME']) == FILENAME_SHOPPING_CART){
          if(isset($_SESSION['default_shipping_countries_id']) and $_SESSION['default_shipping_countries_id'] > 0 and $_SESSION['default_shipping_countries_id'] != $country_id){
              $country_id = (int)$_SESSION['default_shipping_countries_id'];
              $country = main::get_country_values($country_id);
              $dest_country = $country['countries_iso_code_2'];
              $tax_zone_id = 0;
          }
      }
      

      $error = false;
      $grID = $this->get_shipping_graduation_groups_id($country_id);

      $this->get_shippingcosts_multiplikator($grID);
      $this->get_shippingcosts_products_multiplikator($grID);
      $this->get_shippingcosts_only_max($grID);
      $this->get_show_weight($grID);
      $this->get_not_ship($grID);
      $this->get_weight_calc($grID);
      $this->weight = 0;
      if ($this->not_ship == 1 and !$order->is_ebay) {
      	$error = true;
      }

      if ($grID == 0) {
        $error = true;
      } else {
		$shipping = 0;
		$product_shipping = 0;
		$pweight = 0;
		foreach($order->products as $k=>$product){
			if($this->weight_calc == 1){
				$qty = ($this->shippingcosts_products_multiplikator > 0) ? 1 : $product['qty'];
				$pweight += xtc_get_ext_products_weight($product['id'])*$qty;
				$shipping_extra_charge = $this->get_shipping_extra_charge($product['id']);
                                $shipping_extra_charge += main::get_product_shipping_extra_charges($product['id'], $grID);
				$product_shipping += $shipping_extra_charge;
			}else{
				if(main::get_ext_shipping_costs_status($product['id'])){
                                        $ext_additionalcosts_value = $this->get_shipping_extra_charge($product['id']);
					$ext_additionalcosts_value += main::get_product_shipping_extra_charges($product['id'], $grID);
					$qty = ($this->shippingcosts_products_multiplikator > 0) ? 1 : $product['qty'];
					$ext_additionalcosts = $ext_additionalcosts_value*$qty;
		
					// ERWEITERTE KOSTEN JE PRODUKT
					$ext_costs = main::get_ext_shipping_costs($product['id'],$qty);
					foreach($ext_costs as $e_group_id => $e_v){
						if($e_group_id == $grID){
							$debug_string = '';
							foreach($e_v as $e_qty => $ext_value){
								if( $qty >= $e_qty){
									$product_shipping = $ext_value+$ext_additionalcosts;
									$debug_string = $e_qty;
								}
							}
						}
					}
				}else{
					// VERSANDMATRIX
		
					$qty = ($this->shippingcosts_products_multiplikator > 0) ? 1 : $product['qty'];
		
					$grad_query = xtc_db_query("select * from shipping_graduation order by value ASC");
					$Gactive = true;
					$debug_string = '';
					while ($grad = xtc_db_fetch_array($grad_query)) {
						if($qty >= $grad['value']){
							$debug_string = $grad['value'];
							$gID = $grad['shipping_graduation_id'];
						}
					}
					// pweight nehmen wir fuer die kalkulation des Preises
					$pweight = xtc_get_ext_products_weight($product['id'])*$qty;
					$weight_query = xtc_db_query("select * from shipping_graduation_weights order by weight DESC");
                                        $wID = 0;
					while ($weight = xtc_db_fetch_array($weight_query)) {
                                            if((float)$pweight <= (float)$weight['weight']){
                                                $wID = $weight['shipping_graduation_weights_id'];
                                            }
					}
                                        if($wID == 0){
                                            $error = true;
                                        }else{
                                            $grad_query_raw = sprintf(
                                                "SELECT grad_value FROM shipping_graduation_values WHERE shipping_graduation_weights_id='%d' and shipping_graduation_groups_id='%d' and shipping_graduation_id='%d'",
                                                $wID,$grID,$gID
                                            );
                                            $grad_query = xtc_db_query($grad_query_raw);
                                            $grad = xtc_db_fetch_array($grad_query);
                                            $product_shipping = $grad['grad_value'];
                                            $shipping_extra_charge = $this->get_shipping_extra_charge($product['id']);
                                            $shipping_extra_charge += main::get_product_shipping_extra_charges($product['id'],$grID);
                                            $product_shipping += $shipping_extra_charge;
                                        }
				}
				if( $this->shippingcosts_only_max < 1 ){
					$shipping += (float)$product_shipping;
				}else{
					if( (float)$product_shipping > $shipping){
						$shipping = (float)$product_shipping;
					}
				}
			} // end if weight_calc

			// diese Variable fuer die Anzeige des Gewichts
			$this->weight += xtc_get_ext_products_weight($product['id'])*$product['qty'];
		}
		if($this->weight_calc == 1){
			$qty = 1; // gesamtgewicht basierend auf 1 stk
			$grad_query = xtc_db_query("select * from shipping_graduation order by value ASC");
			while ($grad = xtc_db_fetch_array($grad_query)) {
				if($qty >= $grad['value']){
					$gID = $grad['shipping_graduation_id'];
				}
			}
			$weight_query = xtc_db_query("select * from shipping_graduation_weights order by weight DESC");
			while ($weight = xtc_db_fetch_array($weight_query)) {
				if((float)$pweight <= (float)$weight['weight']){
					$wID = $weight['shipping_graduation_weights_id'];
				}
			}
			$grad_query_raw = sprintf("SELECT grad_value FROM shipping_graduation_values WHERE shipping_graduation_weights_id='%s' and shipping_graduation_groups_id='%s' and shipping_graduation_id='%s'",$wID,$grID,$gID);
			$grad_query = xtc_db_query($grad_query_raw);
			$grad = xtc_db_fetch_array($grad_query);
			$shipping = $product_shipping+$grad['grad_value'];
		}
		$shipping_method = MODULE_SHIPPING_YES_TEXT_WAY . ' ' . $dest_country;
		if($this->show_weight > 0)
			$shipping_method .= ' ('.number_format($this->weight,2,',','.').' kg)';

			// NEUES HANDLING  - 0 EUR EGAL
			$shipping_cost = ($shipping + MODULE_SHIPPING_YES_HANDLING);
			$shipping_cost = ((float)$shipping + MODULE_SHIPPING_YES_HANDLING);
			// NEU ENDE
	}
        $this->quotes = array(
            'id' => $this->code,
            'module' => MODULE_SHIPPING_YES_TEXT_TITLE,
            'methods' => array(array(
                'id' => $this->code,
                'title' => $shipping_method,
                'cost' => $shipping_cost
            ))
        );

        $class_methods = get_class_methods('order');
        if(!is_array($class_methods)) $class_methods = array();
        if(in_array('get_shipping_tax_class',$class_methods)){
                $tax_class_id = $order->get_shipping_tax_class();
        }else{
                $tax_class_id = $this->get_shipping_tax_class($order);
        }
        if ($tax_class_id > 0) {
            $tax_country_id = $country_id;
            $this->quotes['tax'] = xtc_get_tax_rate($tax_class_id, $tax_country_id, $tax_zone_id);
            $this->quotes['tax_class_id'] = $tax_class_id;
        }
        if (xtc_not_null($this->icon)) $this->quotes['icon'] = xtc_image($this->icon, $this->title);
        if ($error == true) $this->quotes['error'] = MODULE_SHIPPING_YES_INVALID_ZONE;
        return $this->quotes;
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_SHIPPING_YES_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) VALUES ('MODULE_SHIPPING_YES_STATUS', 'True', '6', '0', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_YES_HANDLING', '0', '6', '0', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, use_function, set_function, date_added) values ('MODULE_SHIPPING_YES_TAX_CLASS', '0', '6', '0', 'xtc_get_tax_class_title', 'xtc_cfg_pull_down_tax_classes(', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_YES_SORT_ORDER', '0', '6', '0', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_YES_ALLOWED', '', '6', '0', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_YES_COST', '', '6', '0', now())");
    }

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      $keys = array('MODULE_SHIPPING_YES_STATUS', 'MODULE_SHIPPING_YES_HANDLING','MODULE_SHIPPING_YES_ALLOWED', 'MODULE_SHIPPING_YES_TAX_CLASS', 'MODULE_SHIPPING_YES_SORT_ORDER', 'MODULE_SHIPPING_YES_COST');
      return $keys;
    }

    function get_shipping_graduation_groups_id($country_id){
	$grID = 0;
	$grid_res = yes_query(
            "SELECT shipping_graduation_groups_id FROM shipping_graduation_countries WHERE country_id=:country_id",
            ['country_id'=>(int)$country_id],
            true
        );
	if($grid_res['shipping_graduation_groups_id'] < 1){
            return $this->GROUP_ID_OTHER;
        }
	return (int)$grid_res['shipping_graduation_groups_id'];
    }

    function get_shippingcosts_only_max($gID){
        $groups = yes_query(
            "SELECT shippingcosts_only_max FROM shipping_graduation_groups WHERE shipping_graduation_groups_id=:groups_id",
            ['groups_id'=>(int)$gID],
            true
        );
        $this->shippingcosts_only_max = $groups['shippingcosts_only_max'];
    }

    function get_shippingcosts_products_multiplikator($gID){
      $groups = yes_query(
        "SELECT shippingcosts_products_multiplikator FROM shipping_graduation_groups WHERE shipping_graduation_groups_id=:groups_id",
        ['groups_id'=>$gID],
        true
      );
      $this->shippingcosts_products_multiplikator = $groups['shippingcosts_products_multiplikator'];
    }

    function get_shippingcosts_multiplikator($gID){
      $groups = yes_query(
        "SELECT shippingcosts_multiplikator FROM shipping_graduation_groups WHERE shipping_graduation_groups_id=:groups_id",
        ['groups_id'=>$gID],
        true
      );
      $this->shippingcosts_multiplikator = $groups['shippingcosts_multiplikator'];
    }

    function get_show_weight($gID){
      $groups = yes_query(
        "SELECT show_weight FROM shipping_graduation_groups WHERE shipping_graduation_groups_id=:groups_id",
        ['groups_id'=>$gID],
        true
      );
      $this->show_weight = $groups['show_weight'];
    }

    function get_weight_calc($gID){
        $this->weight_calc = main::get_weight_calc($gID);
    }

    function get_not_ship($gID){
      $groups = yes_query(
        "SELECT not_ship FROM shipping_graduation_groups WHERE shipping_graduation_groups_id=:groups_id",
        ['groups_id'=>$gID],
        true
      );
      $this->not_ship = $groups['not_ship'];
    }


    function get_ext_shipping_costs_status($products_id){
        return main::get_ext_shipping_costs_status($products_id);
    }

    function get_ext_shipping_costs($products_id){
        return main::get_ext_shipping_costs($products_id);
    }
    
    // OBSOLETE
    function get_shipping_extra_charge($products_id){
	$extra_charge = yes_query(
            "SELECT shipping_extra_charge FROM products WHERE products_id=:products_id",
            ['products_id'=>$products_id],
            true
        );
	return $extra_charge['shipping_extra_charge'];
    }
}
