<?php
function smarty_function_assign_products_categories_data($params,&$smarty){
    if(!function_exists('shopstat_getSEO')){
        require_once(DIR_FS_INC.'shopstat_functions.inc.php');
    }
    $return_array = [];
    if(!isset($params['products_id']) or empty($params['products_id']) or ($params['products_id'] < 1)){
        return $return_array;
    }
    $query = yes_query(
        "SELECT p2c.categories_id,cd.categories_name FROM products_to_categories p2c LEFT JOIN categories_description cd USING(categories_id) WHERE products_id=:products_id AND language_id=:language_id",
        [
            'products_id'=>$params['products_id'], 
            'language_id'=>intval($_SESSION['languages_id'] ?? 2)
        ]
    );
    $categories_array = [];
    foreach($query as $record){
        $categories_array[] = $record;
    }
    foreach($categories_array as $c){
	$return_array[] = array(
		'ID'=>$c['categories_id'],
		'NAME'=>xtc_db_prepare_input($c['categories_name']),
		'LINK'=>shopstat_hrefCatlink(xtc_db_prepare_input($c['categories_name']), $c['categories_id'])
	);
    }
    
    $smarty->assign($params['var'],$return_array);
}

