<?php
/* -----------------------------------------------------------------------------------------
   $Id: popup_image.php,v 1.4 2012/08/13 08:03:42 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2004 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(popup_image.php,v 1.12 2001/12/12); www.oscommerce.com 

   Released under the GNU General Public License 
   -----------------------------------------------------------------------------------------
   Third Party contributions:
   Modified by BIA Solutions (www.biasolutions.com) to create a bordered look to the image

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/

require('includes/application_top.php');
require_once(DIR_FS_INC . 'xtc_get_products_mo_images.inc.php');
$imgID = (isset($_GET['imgID'])) ? max(0,yes_getIntFromRequest('imgID')) : 0;
$pID = (isset($_GET['pID']))?max(0,yes_getIntFromRequest('pID')):0;
if($pID < 1){
    die('invalid parameters');
}
if ($imgID === 0) {
    $parameters = [
        'products_id'=> $pID,
        'language_id'=> intval($_SESSION['languages_id'])
    ];
    $products_query_raw = sprintf(
        "select pd.products_name, p.products_image from %s p left join %s pd USING(products_id) WHERE p.products_id =:products_id and pd.language_id =:language_id and p.products_status=1",
        TABLE_PRODUCTS, TABLE_PRODUCTS_DESCRIPTION
    );
    $products_values = yes_query($products_query_raw,$parameters,true);
    if(!is_countable($products_values) or !sizeOf($products_values)){
        die('Invalid item');
    }
} else {
    $parameters = [
        'products_id'=> $pID,
        'language_id'=> intval($_SESSION['languages_id']),
        'image_id'=>$imgID,
    ];
    $products_query_raw = sprintf(
        "select pd.products_name, p.products_image, pi.image_name from %s pi, %s p left join %s pd USING(products_id) WHERE p.products_id =:products_id and pi.products_id = p.products_id and pi.image_nr =:image_id and pd.language_id =:language_id and p.products_status=1",
        TABLE_PRODUCTS_IMAGES, TABLE_PRODUCTS,TABLE_PRODUCTS_DESCRIPTION
    );
    $products_values = yes_query($products_query_raw,$parameters,true);
    if(!is_countable($products_values) or !sizeOf($products_values)){
        die('Invalid item');
    }
    $products_values['products_image'] = $products_values['image_name'];
}

// get x and y of the image
$img = DIR_WS_POPUP_IMAGES.$products_values['products_image'];
if(is_file($img) and is_readable($img)){
    $size = GetImageSize("$img");
}else{
    die('No popup image available');
}

//get data for mo_images
$mo_images = xtc_get_products_mo_images($pID);
$img = DIR_WS_THUMBNAIL_IMAGES.$products_values['products_image'];
if(is_file($img) and is_readable($img)){
    $osize = GetImageSize("$img");
}else{
    die('No thumbnail image available');
}
if (sizeOf($mo_images)){	
    //$bwidth = $osize[0];
    $bheight = $osize[1];
    foreach ($mo_images as $mo_img){		  
        if($mo_img['noshop'] == 0){
            $img = DIR_WS_THUMBNAIL_IMAGES.$mo_img['image_name'];
            if(is_file($img) and is_readable($img)){
                $mo_size = GetImageSize("$img");
                if ($mo_size[1] > $bheight) {
                    $bheight = $mo_size[1];
                }
            }
        }
    }
    $bheight += 50;
}
?>
<!DOCTYPE html>
<html lang="de">
<head>
    <title><?php echo $products_values['products_name']; ?></title>
    <base href="<?php echo (getenv('HTTPS') == 'on' ? HTTPS_SERVER : HTTP_SERVER) . DIR_WS_CATALOG; ?>">
    <link rel="stylesheet" type="text/css" href="templates/<?php echo CURRENT_TEMPLATE;?>/stylesheet.css">
<script type="text/javascript">
var i=0;
function resize() {
    window.resizeTo(<?php echo $size[0]; ?> +105, <?php echo $size[1] + $bheight; ?>+125);
    self.focus();
}
</script>
</head>
<body onload="resize();">
<table width="100%"  border="0" cellspacing="0" cellpadding="0" bgcolor="white">
    <tr>
        <td bgcolor="#283758"><div align="center"><font color="#FFFFFF" size="2" face="Verdana, Arial, Helvetica, sans-serif"><strong><?php echo $products_values['products_name']; ?></strong></font></div></td>
    </tr>
    <tr>
        <td>
            <table border=0 align="center" cellpadding=5 cellspacing=0>
                <tr>
                    <td align=center><?php echo xtc_image(DIR_WS_POPUP_IMAGES . $products_values['products_image'], $products_values['products_name'], $size[0], $size[1]); ?></td>
                </tr>
            </table>
        </td>
    </tr>
</table>

<!-- thumbs -->
<center>
<?php
if (isset($mo_images)){		
?>
<iframe src="<?php echo 'show_product_thumbs.php?pID='.$_GET['pID'].'&imgID='.$_GET['imgID']; ?>" width="<?php echo $size[0] +40; ?>" height="<?php echo $bheight+5; ?>" border="0" frameborder="0">
    <a href="<?php echo 'show_product_thumbs.php?pID='.$_GET['pID'].'&imgID='.$_GET['imgID']; ?>">More Images</a>
</iframe><br>
<?php
}
?>
<a href="#" onClick='window.close();'><?php echo TEXT_CLOSE_WINDOW ?></a>
</body>
</html>