<?php

$box_smarty = new yessmarty;
$box_smarty->assign('language', $_SESSION['language']);

$key = sprintf('BOX-%s-fsk%s-GETm%s',
    basename(__FILE__),
    $_SESSION['customers_status']['customers_fsk18_display'],
    md5($_GET['manufacturers_id']??'')
);    
$CachedString = $InstanceCache->getItem($key);
if (!$CachedString->isHit()) {
    $box_smarty->assign('tpl_path', 'templates/'.CURRENT_TEMPLATE.'/');
    $Output = false;
    // FSK-Kontrolle
    if ($_SESSION['customers_status']['customers_fsk18_display'] == '0') {
            $fsk_lock = " and p.products_fsk18 != 1 ";
    }
    // Kundengruppen-Check

    $manufacturers_query = xtc_db_query("
        select distinct 
        m.manufacturers_id, 
        m.manufacturers_name,
        m.manufacturers_image  
        from 	".TABLE_MANUFACTURERS." m, 
        ".TABLE_PRODUCTS." p 
        where m.manufacturers_id = p.manufacturers_id
        and p.products_status = 1
        ".$fsk_lock."
        order by m.manufacturers_name
    ");

    while ($manufacturers = xtc_db_fetch_array($manufacturers_query)) {
        $Output[] = array(
            'name'	=>	$manufacturers['manufacturers_name'],
            'link'	=>	xtc_href_link(FILENAME_DEFAULT, xtc_manufacturer_link($manufacturers['manufacturers_id'],$manufacturers['manufacturers_name'])),
            'image'	=>	is_file(DIR_WS_IMAGES.$manufacturers['manufacturers_image']) ? DIR_WS_IMAGES.$manufacturers['manufacturers_image'] : false,
            'class'	=>	(htmlspecialchars($_GET['manufacturers_id'],ENT_QUOTES) == $manufacturers['manufacturers_id']) ? ' class="Current"' : false
        );
    }

    if ($Output) {
        $box_smarty->assign('MAX_DISPLAY_MANUFACTURERS_IN_A_LIST',MAX_DISPLAY_MANUFACTURERS_IN_A_LIST);
        $box_smarty->assign('MANUFACTURERS_SIZE',sizeOf($Output));
        $box_smarty->assign('BOX_CONTENT', $Output);
    }
    $box_manufacturers = $box_smarty->fetch(CURRENT_TEMPLATE.'/boxes/box_manufacturers.html');
    $CachedString->set($box_manufacturers)->expiresAfter(YES_CACHE_LIFETIME_LONG)->addTag('shop');//BOX-*
    $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
}else{
    $box_manufacturers = $CachedString->get();
}

$smarty->assign('box_MANUFACTURERS', $box_manufacturers);
