<?php
/**
 * ItemVariationsByMarketplace
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Catalog Items
 *
 * The Selling Partner API for Catalog Items provides programmatic access to information about items in the Amazon catalog. For more information, see the [Catalog Items API Use Case Guide](https://developer-docs.amazon.com/sp-api/docs/catalog-items-api-v2020-12-01-use-case-guide).
 *
 * The version of the OpenAPI document: 2020-12-01
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\CatalogItemsV20201201;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;

/**
 * ItemVariationsByMarketplace Class Doc Comment
 *
 * @category Class
 * @description Variation details for the Amazon catalog item for the indicated Amazon marketplace.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class ItemVariationsByMarketplace extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ItemVariationsByMarketplace';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'marketplace_id' => 'string',
        'asins' => 'string[]',
        'variation_type' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'marketplace_id' => null,
        'asins' => null,
        'variation_type' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'marketplace_id' => 'marketplaceId',
        'asins' => 'asins',
        'variation_type' => 'variationType'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'marketplace_id' => 'setMarketplaceId',
        'asins' => 'setAsins',
        'variation_type' => 'setVariationType'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'marketplace_id' => 'getMarketplaceId',
        'asins' => 'getAsins',
        'variation_type' => 'getVariationType'
    ];



    const VARIATION_TYPE_PARENT = 'PARENT';
    const VARIATION_TYPE_CHILD = 'CHILD';
    
    

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getVariationTypeAllowableValues()
    {
        $baseVals = [
            self::VARIATION_TYPE_PARENT,
            self::VARIATION_TYPE_CHILD,
        ];

        // This is necessary because Amazon does not consistently capitalize their
        // enum values, so we do case-insensitive enum value validation in ObjectSerializer
        return array_map(function ($val) { return strtoupper($val); }, $baseVals);
    }
    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['marketplace_id'] = $data['marketplace_id'] ?? null;
        $this->container['asins'] = $data['asins'] ?? null;
        $this->container['variation_type'] = $data['variation_type'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        if ($this->container['marketplace_id'] === null) {
            $invalidProperties[] = "'marketplace_id' can't be null";
        }
        if ($this->container['asins'] === null) {
            $invalidProperties[] = "'asins' can't be null";
        }
        if ($this->container['variation_type'] === null) {
            $invalidProperties[] = "'variation_type' can't be null";
        }
        $allowedValues = $this->getVariationTypeAllowableValues();
        if (
            !is_null($this->container['variation_type']) &&
            !in_array(strtoupper($this->container['variation_type']), $allowedValues, true)
        ) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'variation_type', must be one of '%s'",
                $this->container['variation_type'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }


    /**
     * Gets marketplace_id
     *
     * @return string
     */
    public function getMarketplaceId()
    {
        return $this->container['marketplace_id'];
    }

    /**
     * Sets marketplace_id
     *
     * @param string $marketplace_id Amazon marketplace identifier.
     *
     * @return self
     */
    public function setMarketplaceId($marketplace_id)
    {
        $this->container['marketplace_id'] = $marketplace_id;

        return $this;
    }
    /**
     * Gets asins
     *
     * @return string[]
     */
    public function getAsins()
    {
        return $this->container['asins'];
    }

    /**
     * Sets asins
     *
     * @param string[] $asins Identifiers (ASINs) of the related items.
     *
     * @return self
     */
    public function setAsins($asins)
    {
        $this->container['asins'] = $asins;

        return $this;
    }
    /**
     * Gets variation_type
     *
     * @return string
     */
    public function getVariationType()
    {
        return $this->container['variation_type'];
    }

    /**
     * Sets variation_type
     *
     * @param string $variation_type Type of variation relationship of the Amazon catalog item in the request to the related item(s): \"PARENT\" or \"CHILD\".
     *
     * @return self
     */
    public function setVariationType($variation_type)
    {
        $allowedValues = $this->getVariationTypeAllowableValues();
        if (!in_array(strtoupper($variation_type), $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'variation_type', must be one of '%s'",
                    $variation_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['variation_type'] = $variation_type;

        return $this;
    }
}


