<?php
/**
 * DeliveryPreferences
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Orders
 *
 * The Selling Partner API for Orders helps you programmatically retrieve order information. These APIs let you develop fast, flexible, custom applications in areas like order synchronization, order research, and demand-based decision support tools. The Orders API only supports orders that are less than two years old. Orders more than two years old will not show in the API response.
 *
 * The version of the OpenAPI document: v0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\OrdersV0;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;

/**
 * DeliveryPreferences Class Doc Comment
 *
 * @category Class
 * @description Contains all of the delivery instructions provided by the customer for the shipping address.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class DeliveryPreferences extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'DeliveryPreferences';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'drop_off_location' => 'string',
        'preferred_delivery_time' => '\SellingPartnerApi\Model\OrdersV0\PreferredDeliveryTime',
        'other_attributes' => '\SellingPartnerApi\Model\OrdersV0\OtherDeliveryAttributes[]',
        'address_instructions' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'drop_off_location' => null,
        'preferred_delivery_time' => null,
        'other_attributes' => null,
        'address_instructions' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'drop_off_location' => 'DropOffLocation',
        'preferred_delivery_time' => 'PreferredDeliveryTime',
        'other_attributes' => 'OtherAttributes',
        'address_instructions' => 'AddressInstructions'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'drop_off_location' => 'setDropOffLocation',
        'preferred_delivery_time' => 'setPreferredDeliveryTime',
        'other_attributes' => 'setOtherAttributes',
        'address_instructions' => 'setAddressInstructions'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'drop_off_location' => 'getDropOffLocation',
        'preferred_delivery_time' => 'getPreferredDeliveryTime',
        'other_attributes' => 'getOtherAttributes',
        'address_instructions' => 'getAddressInstructions'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['drop_off_location'] = $data['drop_off_location'] ?? null;
        $this->container['preferred_delivery_time'] = $data['preferred_delivery_time'] ?? null;
        $this->container['other_attributes'] = $data['other_attributes'] ?? null;
        $this->container['address_instructions'] = $data['address_instructions'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        return $invalidProperties;
    }


    /**
     * Gets drop_off_location
     *
     * @return string|null
     */
    public function getDropOffLocation()
    {
        return $this->container['drop_off_location'];
    }

    /**
     * Sets drop_off_location
     *
     * @param string|null $drop_off_location Drop-off location selected by the customer.
     *
     * @return self
     */
    public function setDropOffLocation($drop_off_location)
    {
        $this->container['drop_off_location'] = $drop_off_location;

        return $this;
    }
    /**
     * Gets preferred_delivery_time
     *
     * @return \SellingPartnerApi\Model\OrdersV0\PreferredDeliveryTime|null
     */
    public function getPreferredDeliveryTime()
    {
        return $this->container['preferred_delivery_time'];
    }

    /**
     * Sets preferred_delivery_time
     *
     * @param \SellingPartnerApi\Model\OrdersV0\PreferredDeliveryTime|null $preferred_delivery_time preferred_delivery_time
     *
     * @return self
     */
    public function setPreferredDeliveryTime($preferred_delivery_time)
    {
        $this->container['preferred_delivery_time'] = $preferred_delivery_time;

        return $this;
    }
    /**
     * Gets other_attributes
     *
     * @return \SellingPartnerApi\Model\OrdersV0\OtherDeliveryAttributes[]|null
     */
    public function getOtherAttributes()
    {
        return $this->container['other_attributes'];
    }

    /**
     * Sets other_attributes
     *
     * @param \SellingPartnerApi\Model\OrdersV0\OtherDeliveryAttributes[]|null $other_attributes Enumerated list of miscellaneous delivery attributes associated with the shipping address.
     *
     * @return self
     */
    public function setOtherAttributes($other_attributes)
    {
        $this->container['other_attributes'] = $other_attributes;

        return $this;
    }
    /**
     * Gets address_instructions
     *
     * @return string|null
     */
    public function getAddressInstructions()
    {
        return $this->container['address_instructions'];
    }

    /**
     * Sets address_instructions
     *
     * @param string|null $address_instructions Building instructions, nearby landmark or navigation instructions.
     *
     * @return self
     */
    public function setAddressInstructions($address_instructions)
    {
        $this->container['address_instructions'] = $address_instructions;

        return $this;
    }
}


